package zio.aws.proton.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentTargetResourceType {
  def unwrap: software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType
}
object DeploymentTargetResourceType {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType
  ): zio.aws.proton.model.DeploymentTargetResourceType = value match {
    case software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.ENVIRONMENT =>
      val r = ENVIRONMENT
      r
    case software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.SERVICE_PIPELINE =>
      val r = SERVICE_PIPELINE
      r
    case software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.SERVICE_INSTANCE =>
      val r = SERVICE_INSTANCE
      r
    case software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.COMPONENT =>
      val r = COMPONENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.DeploymentTargetResourceType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType =
      software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENVIRONMENT
      extends zio.aws.proton.model.DeploymentTargetResourceType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType =
      software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.ENVIRONMENT
  }
  case object SERVICE_PIPELINE
      extends zio.aws.proton.model.DeploymentTargetResourceType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType =
      software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.SERVICE_PIPELINE
  }
  case object SERVICE_INSTANCE
      extends zio.aws.proton.model.DeploymentTargetResourceType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType =
      software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.SERVICE_INSTANCE
  }
  case object COMPONENT
      extends zio.aws.proton.model.DeploymentTargetResourceType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType =
      software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType.COMPONENT
  }
}
