package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeploymentState(
    component: Optional[zio.aws.proton.model.ComponentState] = Optional.Absent,
    environment: Optional[zio.aws.proton.model.EnvironmentState] =
      Optional.Absent,
    serviceInstance: Optional[zio.aws.proton.model.ServiceInstanceState] =
      Optional.Absent,
    servicePipeline: Optional[zio.aws.proton.model.ServicePipelineState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeploymentState = {
    import DeploymentState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeploymentState
      .builder()
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(serviceInstance.map(value => value.buildAwsValue()))(
        _.serviceInstance
      )
      .optionallyWith(servicePipeline.map(value => value.buildAwsValue()))(
        _.servicePipeline
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeploymentState.ReadOnly =
    zio.aws.proton.model.DeploymentState.wrap(buildAwsValue())
}
object DeploymentState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeploymentState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeploymentState =
      zio.aws.proton.model.DeploymentState(
        component.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        serviceInstance.map(value => value.asEditable),
        servicePipeline.map(value => value.asEditable)
      )
    def component: Optional[zio.aws.proton.model.ComponentState.ReadOnly]
    def environment: Optional[zio.aws.proton.model.EnvironmentState.ReadOnly]
    def serviceInstance
        : Optional[zio.aws.proton.model.ServiceInstanceState.ReadOnly]
    def servicePipeline
        : Optional[zio.aws.proton.model.ServicePipelineState.ReadOnly]
    def getComponent
        : ZIO[Any, AwsError, zio.aws.proton.model.ComponentState.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.proton.model.EnvironmentState.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
    def getServiceInstance: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ServiceInstanceState.ReadOnly
    ] = AwsError.unwrapOptionField("serviceInstance", serviceInstance)
    def getServicePipeline: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ServicePipelineState.ReadOnly
    ] = AwsError.unwrapOptionField("servicePipeline", servicePipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeploymentState
  ) extends zio.aws.proton.model.DeploymentState.ReadOnly {
    override val component
        : Optional[zio.aws.proton.model.ComponentState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.component())
        .map(value => zio.aws.proton.model.ComponentState.wrap(value))
    override val environment
        : Optional[zio.aws.proton.model.EnvironmentState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.proton.model.EnvironmentState.wrap(value))
    override val serviceInstance
        : Optional[zio.aws.proton.model.ServiceInstanceState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstance())
        .map(value => zio.aws.proton.model.ServiceInstanceState.wrap(value))
    override val servicePipeline
        : Optional[zio.aws.proton.model.ServicePipelineState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.servicePipeline())
        .map(value => zio.aws.proton.model.ServicePipelineState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeploymentState
  ): zio.aws.proton.model.DeploymentState.ReadOnly = new Wrapper(impl)
}
