package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  Timestamp,
  Arn,
  DeploymentId,
  DeploymentArn,
  StatusMessage,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class Deployment(
    arn: DeploymentArn,
    completedAt: Optional[Timestamp] = Optional.Absent,
    componentName: Optional[ResourceName] = Optional.Absent,
    createdAt: Timestamp,
    deploymentStatus: zio.aws.proton.model.DeploymentStatus,
    deploymentStatusMessage: Optional[StatusMessage] = Optional.Absent,
    environmentName: ResourceName,
    id: DeploymentId,
    initialState: Optional[zio.aws.proton.model.DeploymentState] =
      Optional.Absent,
    lastAttemptedDeploymentId: Optional[DeploymentId] = Optional.Absent,
    lastModifiedAt: Timestamp,
    lastSucceededDeploymentId: Optional[DeploymentId] = Optional.Absent,
    serviceInstanceName: Optional[ResourceName] = Optional.Absent,
    serviceName: Optional[ResourceName] = Optional.Absent,
    targetArn: Arn,
    targetResourceCreatedAt: Timestamp,
    targetResourceType: zio.aws.proton.model.DeploymentTargetResourceType,
    targetState: Optional[zio.aws.proton.model.DeploymentState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.Deployment = {
    import Deployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.Deployment
      .builder()
      .arn(DeploymentArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        completedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.completedAt)
      .optionallyWith(
        componentName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.componentName)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .deploymentStatus(deploymentStatus.unwrap)
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .id(DeploymentId.unwrap(id): java.lang.String)
      .optionallyWith(initialState.map(value => value.buildAwsValue()))(
        _.initialState
      )
      .optionallyWith(
        lastAttemptedDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastAttemptedDeploymentId)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .optionallyWith(
        lastSucceededDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.lastSucceededDeploymentId)
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .optionallyWith(
        serviceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .targetArn(Arn.unwrap(targetArn): java.lang.String)
      .targetResourceCreatedAt(
        Timestamp.unwrap(targetResourceCreatedAt): Instant
      )
      .targetResourceType(targetResourceType.unwrap)
      .optionallyWith(targetState.map(value => value.buildAwsValue()))(
        _.targetState
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.Deployment.ReadOnly =
    zio.aws.proton.model.Deployment.wrap(buildAwsValue())
}
object Deployment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.proton.model.Deployment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.Deployment =
      zio.aws.proton.model.Deployment(
        arn,
        completedAt.map(value => value),
        componentName.map(value => value),
        createdAt,
        deploymentStatus,
        deploymentStatusMessage.map(value => value),
        environmentName,
        id,
        initialState.map(value => value.asEditable),
        lastAttemptedDeploymentId.map(value => value),
        lastModifiedAt,
        lastSucceededDeploymentId.map(value => value),
        serviceInstanceName.map(value => value),
        serviceName.map(value => value),
        targetArn,
        targetResourceCreatedAt,
        targetResourceType,
        targetState.map(value => value.asEditable)
      )
    def arn: DeploymentArn
    def completedAt: Optional[Timestamp]
    def componentName: Optional[ResourceName]
    def createdAt: Timestamp
    def deploymentStatus: zio.aws.proton.model.DeploymentStatus
    def deploymentStatusMessage: Optional[StatusMessage]
    def environmentName: ResourceName
    def id: DeploymentId
    def initialState: Optional[zio.aws.proton.model.DeploymentState.ReadOnly]
    def lastAttemptedDeploymentId: Optional[DeploymentId]
    def lastModifiedAt: Timestamp
    def lastSucceededDeploymentId: Optional[DeploymentId]
    def serviceInstanceName: Optional[ResourceName]
    def serviceName: Optional[ResourceName]
    def targetArn: Arn
    def targetResourceCreatedAt: Timestamp
    def targetResourceType: zio.aws.proton.model.DeploymentTargetResourceType
    def targetState: Optional[zio.aws.proton.model.DeploymentState.ReadOnly]
    def getArn: ZIO[Any, Nothing, DeploymentArn] = ZIO.succeed(arn)
    def getCompletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completedAt", completedAt)
    def getComponentName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDeploymentStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentStatus] =
      ZIO.succeed(deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, StatusMessage] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, DeploymentId] = ZIO.succeed(id)
    def getInitialState
        : ZIO[Any, AwsError, zio.aws.proton.model.DeploymentState.ReadOnly] =
      AwsError.unwrapOptionField("initialState", initialState)
    def getLastAttemptedDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField(
        "lastAttemptedDeploymentId",
        lastAttemptedDeploymentId
      )
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getLastSucceededDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField(
        "lastSucceededDeploymentId",
        lastSucceededDeploymentId
      )
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getTargetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(targetArn)
    def getTargetResourceCreatedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(targetResourceCreatedAt)
    def getTargetResourceType
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentTargetResourceType] =
      ZIO.succeed(targetResourceType)
    def getTargetState
        : ZIO[Any, AwsError, zio.aws.proton.model.DeploymentState.ReadOnly] =
      AwsError.unwrapOptionField("targetState", targetState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.Deployment
  ) extends zio.aws.proton.model.Deployment.ReadOnly {
    override val arn: DeploymentArn =
      zio.aws.proton.model.primitives.DeploymentArn(impl.arn())
    override val completedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completedAt())
      .map(value => zio.aws.proton.model.primitives.Timestamp(value))
    override val componentName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val deploymentStatus: zio.aws.proton.model.DeploymentStatus =
      zio.aws.proton.model.DeploymentStatus.wrap(impl.deploymentStatus())
    override val deploymentStatusMessage: Optional[StatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val id: DeploymentId =
      zio.aws.proton.model.primitives.DeploymentId(impl.id())
    override val initialState
        : Optional[zio.aws.proton.model.DeploymentState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialState())
        .map(value => zio.aws.proton.model.DeploymentState.wrap(value))
    override val lastAttemptedDeploymentId: Optional[DeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAttemptedDeploymentId())
        .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val lastSucceededDeploymentId: Optional[DeploymentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSucceededDeploymentId())
        .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val serviceInstanceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val targetArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.targetArn())
    override val targetResourceCreatedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.targetResourceCreatedAt())
    override val targetResourceType
        : zio.aws.proton.model.DeploymentTargetResourceType =
      zio.aws.proton.model.DeploymentTargetResourceType
        .wrap(impl.targetResourceType())
    override val targetState
        : Optional[zio.aws.proton.model.DeploymentState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetState())
        .map(value => zio.aws.proton.model.DeploymentState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.Deployment
  ): zio.aws.proton.model.Deployment.ReadOnly = new Wrapper(impl)
}
