package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteServiceSyncConfigRequest(serviceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigRequest = {
    import DeleteServiceSyncConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigRequest
      .builder()
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteServiceSyncConfigRequest.ReadOnly =
    zio.aws.proton.model.DeleteServiceSyncConfigRequest.wrap(buildAwsValue())
}
object DeleteServiceSyncConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteServiceSyncConfigRequest =
      zio.aws.proton.model.DeleteServiceSyncConfigRequest(serviceName)
    def serviceName: ResourceName
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigRequest
  ) extends zio.aws.proton.model.DeleteServiceSyncConfigRequest.ReadOnly {
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigRequest
  ): zio.aws.proton.model.DeleteServiceSyncConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
