package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDeploymentResponse(
    deployment: Optional[zio.aws.proton.model.Deployment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteDeploymentResponse = {
    import DeleteDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteDeploymentResponse
      .builder()
      .optionallyWith(deployment.map(value => value.buildAwsValue()))(
        _.deployment
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteDeploymentResponse.ReadOnly =
    zio.aws.proton.model.DeleteDeploymentResponse.wrap(buildAwsValue())
}
object DeleteDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteDeploymentResponse =
      zio.aws.proton.model
        .DeleteDeploymentResponse(deployment.map(value => value.asEditable))
    def deployment: Optional[zio.aws.proton.model.Deployment.ReadOnly]
    def getDeployment
        : ZIO[Any, AwsError, zio.aws.proton.model.Deployment.ReadOnly] =
      AwsError.unwrapOptionField("deployment", deployment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteDeploymentResponse
  ) extends zio.aws.proton.model.DeleteDeploymentResponse.ReadOnly {
    override val deployment
        : Optional[zio.aws.proton.model.Deployment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deployment())
        .map(value => zio.aws.proton.model.Deployment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteDeploymentResponse
  ): zio.aws.proton.model.DeleteDeploymentResponse.ReadOnly = new Wrapper(impl)
}
