package zio.aws.proton.model
import zio.aws.proton.model.primitives.DeploymentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDeploymentRequest(id: DeploymentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteDeploymentRequest = {
    import DeleteDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteDeploymentRequest
      .builder()
      .id(DeploymentId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteDeploymentRequest.ReadOnly =
    zio.aws.proton.model.DeleteDeploymentRequest.wrap(buildAwsValue())
}
object DeleteDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteDeploymentRequest =
      zio.aws.proton.model.DeleteDeploymentRequest(id)
    def id: DeploymentId
    def getId: ZIO[Any, Nothing, DeploymentId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteDeploymentRequest
  ) extends zio.aws.proton.model.DeleteDeploymentRequest.ReadOnly {
    override val id: DeploymentId =
      zio.aws.proton.model.primitives.DeploymentId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteDeploymentRequest
  ): zio.aws.proton.model.DeleteDeploymentRequest.ReadOnly = new Wrapper(impl)
}
