package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateServiceSyncConfigResponse(
    serviceSyncConfig: Optional[zio.aws.proton.model.ServiceSyncConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateServiceSyncConfigResponse = {
    import CreateServiceSyncConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateServiceSyncConfigResponse
      .builder()
      .optionallyWith(serviceSyncConfig.map(value => value.buildAwsValue()))(
        _.serviceSyncConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateServiceSyncConfigResponse.ReadOnly =
    zio.aws.proton.model.CreateServiceSyncConfigResponse.wrap(buildAwsValue())
}
object CreateServiceSyncConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateServiceSyncConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateServiceSyncConfigResponse =
      zio.aws.proton.model.CreateServiceSyncConfigResponse(
        serviceSyncConfig.map(value => value.asEditable)
      )
    def serviceSyncConfig
        : Optional[zio.aws.proton.model.ServiceSyncConfig.ReadOnly]
    def getServiceSyncConfig
        : ZIO[Any, AwsError, zio.aws.proton.model.ServiceSyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("serviceSyncConfig", serviceSyncConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceSyncConfigResponse
  ) extends zio.aws.proton.model.CreateServiceSyncConfigResponse.ReadOnly {
    override val serviceSyncConfig
        : Optional[zio.aws.proton.model.ServiceSyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceSyncConfig())
        .map(value => zio.aws.proton.model.ServiceSyncConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceSyncConfigResponse
  ): zio.aws.proton.model.CreateServiceSyncConfigResponse.ReadOnly =
    new Wrapper(impl)
}
