package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateServiceInstanceResponse(
    serviceInstance: zio.aws.proton.model.ServiceInstance
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateServiceInstanceResponse = {
    import CreateServiceInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateServiceInstanceResponse
      .builder()
      .serviceInstance(serviceInstance.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateServiceInstanceResponse.ReadOnly =
    zio.aws.proton.model.CreateServiceInstanceResponse.wrap(buildAwsValue())
}
object CreateServiceInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateServiceInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateServiceInstanceResponse =
      zio.aws.proton.model
        .CreateServiceInstanceResponse(serviceInstance.asEditable)
    def serviceInstance: zio.aws.proton.model.ServiceInstance.ReadOnly
    def getServiceInstance
        : ZIO[Any, Nothing, zio.aws.proton.model.ServiceInstance.ReadOnly] =
      ZIO.succeed(serviceInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceInstanceResponse
  ) extends zio.aws.proton.model.CreateServiceInstanceResponse.ReadOnly {
    override val serviceInstance
        : zio.aws.proton.model.ServiceInstance.ReadOnly =
      zio.aws.proton.model.ServiceInstance.wrap(impl.serviceInstance())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceInstanceResponse
  ): zio.aws.proton.model.CreateServiceInstanceResponse.ReadOnly = new Wrapper(
    impl
  )
}
