package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  SpecContents,
  ResourceName,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateServiceInstanceRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    name: ResourceName,
    serviceName: ResourceName,
    spec: SpecContents,
    tags: Optional[Iterable[zio.aws.proton.model.Tag]] = Optional.Absent,
    templateMajorVersion: Optional[TemplateVersionPart] = Optional.Absent,
    templateMinorVersion: Optional[TemplateVersionPart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateServiceInstanceRequest = {
    import CreateServiceInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateServiceInstanceRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .name(ResourceName.unwrap(name): java.lang.String)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .spec(SpecContents.unwrap(spec): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        templateMajorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMajorVersion)
      .optionallyWith(
        templateMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMinorVersion)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateServiceInstanceRequest.ReadOnly =
    zio.aws.proton.model.CreateServiceInstanceRequest.wrap(buildAwsValue())
}
object CreateServiceInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateServiceInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateServiceInstanceRequest =
      zio.aws.proton.model.CreateServiceInstanceRequest(
        clientToken.map(value => value),
        name,
        serviceName,
        spec,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        templateMajorVersion.map(value => value),
        templateMinorVersion.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def name: ResourceName
    def serviceName: ResourceName
    def spec: SpecContents
    def tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]]
    def templateMajorVersion: Optional[TemplateVersionPart]
    def templateMinorVersion: Optional[TemplateVersionPart]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
    def getSpec: ZIO[Any, Nothing, SpecContents] = ZIO.succeed(spec)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateMajorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMajorVersion", templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMinorVersion", templateMinorVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceInstanceRequest
  ) extends zio.aws.proton.model.CreateServiceInstanceRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.proton.model.primitives.ClientToken(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
    override val spec: SpecContents =
      zio.aws.proton.model.primitives.SpecContents(impl.spec())
    override val tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Tag.wrap(item)
          }.toList
        )
    override val templateMajorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMajorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
    override val templateMinorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMinorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceInstanceRequest
  ): zio.aws.proton.model.CreateServiceInstanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
