package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  TemplateFileContents,
  SpecContents,
  ResourceNameOrEmpty
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentState(
    serviceInstanceName: Optional[ResourceNameOrEmpty] = Optional.Absent,
    serviceName: Optional[ResourceNameOrEmpty] = Optional.Absent,
    serviceSpec: Optional[SpecContents] = Optional.Absent,
    templateFile: Optional[TemplateFileContents] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ComponentState = {
    import ComponentState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ComponentState
      .builder()
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceNameOrEmpty.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .optionallyWith(
        serviceName.map(value =>
          ResourceNameOrEmpty.unwrap(value): java.lang.String
        )
      )(_.serviceName)
      .optionallyWith(
        serviceSpec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.serviceSpec)
      .optionallyWith(
        templateFile.map(value =>
          TemplateFileContents.unwrap(value): java.lang.String
        )
      )(_.templateFile)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ComponentState.ReadOnly =
    zio.aws.proton.model.ComponentState.wrap(buildAwsValue())
}
object ComponentState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ComponentState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ComponentState =
      zio.aws.proton.model.ComponentState(
        serviceInstanceName.map(value => value),
        serviceName.map(value => value),
        serviceSpec.map(value => value),
        templateFile.map(value => value)
      )
    def serviceInstanceName: Optional[ResourceNameOrEmpty]
    def serviceName: Optional[ResourceNameOrEmpty]
    def serviceSpec: Optional[SpecContents]
    def templateFile: Optional[TemplateFileContents]
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceNameOrEmpty] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, AwsError, ResourceNameOrEmpty] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("serviceSpec", serviceSpec)
    def getTemplateFile: ZIO[Any, AwsError, TemplateFileContents] =
      AwsError.unwrapOptionField("templateFile", templateFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ComponentState
  ) extends zio.aws.proton.model.ComponentState.ReadOnly {
    override val serviceInstanceName: Optional[ResourceNameOrEmpty] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value =>
          zio.aws.proton.model.primitives.ResourceNameOrEmpty(value)
        )
    override val serviceName: Optional[ResourceNameOrEmpty] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceName())
        .map(value =>
          zio.aws.proton.model.primitives.ResourceNameOrEmpty(value)
        )
    override val serviceSpec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceSpec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
    override val templateFile: Optional[TemplateFileContents] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateFile())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateFileContents(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ComponentState
  ): zio.aws.proton.model.ComponentState.ReadOnly = new Wrapper(impl)
}
