package zio.aws.proton.model
import scala.jdk.CollectionConverters._
sealed trait BlockerType {
  def unwrap: software.amazon.awssdk.services.proton.model.BlockerType
}
object BlockerType {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.BlockerType
  ): zio.aws.proton.model.BlockerType = value match {
    case software.amazon.awssdk.services.proton.model.BlockerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.BlockerType.AUTOMATED =>
      val r = AUTOMATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.proton.model.BlockerType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.BlockerType =
      software.amazon.awssdk.services.proton.model.BlockerType.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATED extends zio.aws.proton.model.BlockerType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.BlockerType =
      software.amazon.awssdk.services.proton.model.BlockerType.AUTOMATED
  }
}
