package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  SpecContents,
  Description,
  TemplateFileContents,
  ResourceNameOrEmpty,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateComponentRequest(
    deploymentType: zio.aws.proton.model.ComponentDeploymentUpdateType,
    description: Optional[Description] = Optional.Absent,
    name: ResourceName,
    serviceInstanceName: Optional[ResourceNameOrEmpty] = Optional.Absent,
    serviceName: Optional[ResourceNameOrEmpty] = Optional.Absent,
    serviceSpec: Optional[SpecContents] = Optional.Absent,
    templateFile: Optional[TemplateFileContents] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateComponentRequest = {
    import UpdateComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateComponentRequest
      .builder()
      .deploymentType(deploymentType.unwrap)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceNameOrEmpty.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .optionallyWith(
        serviceName.map(value =>
          ResourceNameOrEmpty.unwrap(value): java.lang.String
        )
      )(_.serviceName)
      .optionallyWith(
        serviceSpec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.serviceSpec)
      .optionallyWith(
        templateFile.map(value =>
          TemplateFileContents.unwrap(value): java.lang.String
        )
      )(_.templateFile)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateComponentRequest.ReadOnly =
    zio.aws.proton.model.UpdateComponentRequest.wrap(buildAwsValue())
}
object UpdateComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateComponentRequest =
      zio.aws.proton.model.UpdateComponentRequest(
        deploymentType,
        description.map(value => value),
        name,
        serviceInstanceName.map(value => value),
        serviceName.map(value => value),
        serviceSpec.map(value => value),
        templateFile.map(value => value)
      )
    def deploymentType: zio.aws.proton.model.ComponentDeploymentUpdateType
    def description: Optional[Description]
    def name: ResourceName
    def serviceInstanceName: Optional[ResourceNameOrEmpty]
    def serviceName: Optional[ResourceNameOrEmpty]
    def serviceSpec: Optional[SpecContents]
    def templateFile: Optional[TemplateFileContents]
    def getDeploymentType: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.ComponentDeploymentUpdateType
    ] = ZIO.succeed(deploymentType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceNameOrEmpty] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, AwsError, ResourceNameOrEmpty] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("serviceSpec", serviceSpec)
    def getTemplateFile: ZIO[Any, AwsError, TemplateFileContents] =
      AwsError.unwrapOptionField("templateFile", templateFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateComponentRequest
  ) extends zio.aws.proton.model.UpdateComponentRequest.ReadOnly {
    override val deploymentType
        : zio.aws.proton.model.ComponentDeploymentUpdateType =
      zio.aws.proton.model.ComponentDeploymentUpdateType
        .wrap(impl.deploymentType())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val serviceInstanceName: Optional[ResourceNameOrEmpty] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value =>
          zio.aws.proton.model.primitives.ResourceNameOrEmpty(value)
        )
    override val serviceName: Optional[ResourceNameOrEmpty] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceName())
        .map(value =>
          zio.aws.proton.model.primitives.ResourceNameOrEmpty(value)
        )
    override val serviceSpec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceSpec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
    override val templateFile: Optional[TemplateFileContents] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateFile())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateFileContents(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateComponentRequest
  ): zio.aws.proton.model.UpdateComponentRequest.ReadOnly = new Wrapper(impl)
}
