package zio.aws.proton.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceCountsSummary(
    behindMajor: Optional[zio.aws.proton.model.primitives.Integer] =
      Optional.Absent,
    behindMinor: Optional[zio.aws.proton.model.primitives.Integer] =
      Optional.Absent,
    failed: Optional[zio.aws.proton.model.primitives.Integer] = Optional.Absent,
    total: zio.aws.proton.model.primitives.Integer,
    upToDate: Optional[zio.aws.proton.model.primitives.Integer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ResourceCountsSummary = {
    import ResourceCountsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ResourceCountsSummary
      .builder()
      .optionallyWith(behindMajor.map(value => value: Integer))(_.behindMajor)
      .optionallyWith(behindMinor.map(value => value: Integer))(_.behindMinor)
      .optionallyWith(failed.map(value => value: Integer))(_.failed)
      .total(total: Integer)
      .optionallyWith(upToDate.map(value => value: Integer))(_.upToDate)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ResourceCountsSummary.ReadOnly =
    zio.aws.proton.model.ResourceCountsSummary.wrap(buildAwsValue())
}
object ResourceCountsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ResourceCountsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ResourceCountsSummary =
      zio.aws.proton.model.ResourceCountsSummary(
        behindMajor.map(value => value),
        behindMinor.map(value => value),
        failed.map(value => value),
        total,
        upToDate.map(value => value)
      )
    def behindMajor: Optional[zio.aws.proton.model.primitives.Integer]
    def behindMinor: Optional[zio.aws.proton.model.primitives.Integer]
    def failed: Optional[zio.aws.proton.model.primitives.Integer]
    def total: zio.aws.proton.model.primitives.Integer
    def upToDate: Optional[zio.aws.proton.model.primitives.Integer]
    def getBehindMajor
        : ZIO[Any, AwsError, zio.aws.proton.model.primitives.Integer] =
      AwsError.unwrapOptionField("behindMajor", behindMajor)
    def getBehindMinor
        : ZIO[Any, AwsError, zio.aws.proton.model.primitives.Integer] =
      AwsError.unwrapOptionField("behindMinor", behindMinor)
    def getFailed: ZIO[Any, AwsError, zio.aws.proton.model.primitives.Integer] =
      AwsError.unwrapOptionField("failed", failed)
    def getTotal: ZIO[Any, Nothing, zio.aws.proton.model.primitives.Integer] =
      ZIO.succeed(total)
    def getUpToDate
        : ZIO[Any, AwsError, zio.aws.proton.model.primitives.Integer] =
      AwsError.unwrapOptionField("upToDate", upToDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ResourceCountsSummary
  ) extends zio.aws.proton.model.ResourceCountsSummary.ReadOnly {
    override val behindMajor
        : Optional[zio.aws.proton.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behindMajor())
        .map(value => value: zio.aws.proton.model.primitives.Integer)
    override val behindMinor
        : Optional[zio.aws.proton.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behindMinor())
        .map(value => value: zio.aws.proton.model.primitives.Integer)
    override val failed: Optional[zio.aws.proton.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failed())
        .map(value => value: zio.aws.proton.model.primitives.Integer)
    override val total: zio.aws.proton.model.primitives.Integer =
      impl.total(): zio.aws.proton.model.primitives.Integer
    override val upToDate: Optional[zio.aws.proton.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upToDate())
        .map(value => value: zio.aws.proton.model.primitives.Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ResourceCountsSummary
  ): zio.aws.proton.model.ResourceCountsSummary.ReadOnly = new Wrapper(impl)
}
