package zio.aws.proton.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.proton.model.primitives.{Arn, MaxPageResults}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    maxResults: Optional[MaxPageResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    resourceArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.proton.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListTagsForResourceRequest =
      zio.aws.proton.model.ListTagsForResourceRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceArn
      )
    def maxResults: Optional[MaxPageResults]
    def nextToken: Optional[String]
    def resourceArn: Arn
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest
  ) extends zio.aws.proton.model.ListTagsForResourceRequest.ReadOnly {
    override val maxResults: Optional[MaxPageResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val resourceArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest
  ): zio.aws.proton.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
