package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetServiceRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceRequest = {
    import GetServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetServiceRequest.ReadOnly =
    zio.aws.proton.model.GetServiceRequest.wrap(buildAwsValue())
}
object GetServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceRequest =
      zio.aws.proton.model.GetServiceRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceRequest
  ) extends zio.aws.proton.model.GetServiceRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceRequest
  ): zio.aws.proton.model.GetServiceRequest.ReadOnly = new Wrapper(impl)
}
