package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TemplateVersionSourceInput(
    s3: Optional[zio.aws.proton.model.S3ObjectSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.TemplateVersionSourceInput = {
    import TemplateVersionSourceInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.TemplateVersionSourceInput
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.TemplateVersionSourceInput.ReadOnly =
    zio.aws.proton.model.TemplateVersionSourceInput.wrap(buildAwsValue())
}
object TemplateVersionSourceInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.TemplateVersionSourceInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.TemplateVersionSourceInput =
      zio.aws.proton.model
        .TemplateVersionSourceInput(s3.map(value => value.asEditable))
    def s3: Optional[zio.aws.proton.model.S3ObjectSource.ReadOnly]
    def getS3
        : ZIO[Any, AwsError, zio.aws.proton.model.S3ObjectSource.ReadOnly] =
      AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.TemplateVersionSourceInput
  ) extends zio.aws.proton.model.TemplateVersionSourceInput.ReadOnly {
    override val s3: Optional[zio.aws.proton.model.S3ObjectSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.proton.model.S3ObjectSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.TemplateVersionSourceInput
  ): zio.aws.proton.model.TemplateVersionSourceInput.ReadOnly = new Wrapper(
    impl
  )
}
