package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  ResourceName,
  StatusMessage,
  Timestamp,
  ComponentArn
}
import scala.jdk.CollectionConverters._
final case class ComponentSummary(
    arn: ComponentArn,
    createdAt: Timestamp,
    deploymentStatus: zio.aws.proton.model.DeploymentStatus,
    deploymentStatusMessage: Optional[StatusMessage] = Optional.Absent,
    environmentName: ResourceName,
    lastDeploymentAttemptedAt: Optional[Timestamp] = Optional.Absent,
    lastDeploymentSucceededAt: Optional[Timestamp] = Optional.Absent,
    lastModifiedAt: Timestamp,
    name: ResourceName,
    serviceInstanceName: Optional[ResourceName] = Optional.Absent,
    serviceName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ComponentSummary = {
    import ComponentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ComponentSummary
      .builder()
      .arn(ComponentArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .deploymentStatus(deploymentStatus.unwrap)
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .optionallyWith(
        lastDeploymentAttemptedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDeploymentAttemptedAt)
      .optionallyWith(
        lastDeploymentSucceededAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDeploymentSucceededAt)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .optionallyWith(
        serviceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ComponentSummary.ReadOnly =
    zio.aws.proton.model.ComponentSummary.wrap(buildAwsValue())
}
object ComponentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ComponentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ComponentSummary =
      zio.aws.proton.model.ComponentSummary(
        arn,
        createdAt,
        deploymentStatus,
        deploymentStatusMessage.map(value => value),
        environmentName,
        lastDeploymentAttemptedAt.map(value => value),
        lastDeploymentSucceededAt.map(value => value),
        lastModifiedAt,
        name,
        serviceInstanceName.map(value => value),
        serviceName.map(value => value)
      )
    def arn: ComponentArn
    def createdAt: Timestamp
    def deploymentStatus: zio.aws.proton.model.DeploymentStatus
    def deploymentStatusMessage: Optional[StatusMessage]
    def environmentName: ResourceName
    def lastDeploymentAttemptedAt: Optional[Timestamp]
    def lastDeploymentSucceededAt: Optional[Timestamp]
    def lastModifiedAt: Timestamp
    def name: ResourceName
    def serviceInstanceName: Optional[ResourceName]
    def serviceName: Optional[ResourceName]
    def getArn: ZIO[Any, Nothing, ComponentArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDeploymentStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentStatus] =
      ZIO.succeed(deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, StatusMessage] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getLastDeploymentAttemptedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDeploymentAttemptedAt", lastDeploymentAttemptedAt)
    def getLastDeploymentSucceededAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDeploymentSucceededAt", lastDeploymentSucceededAt)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ComponentSummary
  ) extends zio.aws.proton.model.ComponentSummary.ReadOnly {
    override val arn: ComponentArn =
      zio.aws.proton.model.primitives.ComponentArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val deploymentStatus: zio.aws.proton.model.DeploymentStatus =
      zio.aws.proton.model.DeploymentStatus.wrap(impl.deploymentStatus())
    override val deploymentStatusMessage: Optional[StatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val lastDeploymentAttemptedAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDeploymentAttemptedAt())
        .map(value => zio.aws.proton.model.primitives.Timestamp(value))
    override val lastDeploymentSucceededAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDeploymentSucceededAt())
        .map(value => zio.aws.proton.model.primitives.Timestamp(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val serviceInstanceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ComponentSummary
  ): zio.aws.proton.model.ComponentSummary.ReadOnly = new Wrapper(impl)
}
