package zio.aws.proton
import zio.aws.proton.model.GetEnvironmentTemplateResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.proton.paginators.{
  ListEnvironmentTemplatesPublisher,
  ListEnvironmentAccountConnectionsPublisher,
  ListComponentProvisionedResourcesPublisher,
  ListRepositorySyncDefinitionsPublisher,
  ListEnvironmentOutputsPublisher,
  ListServicePipelineOutputsPublisher,
  ListServiceInstanceProvisionedResourcesPublisher,
  ListEnvironmentsPublisher,
  ListServicesPublisher,
  ListServicePipelineProvisionedResourcesPublisher,
  ListServiceTemplateVersionsPublisher,
  ListServiceTemplatesPublisher,
  ListEnvironmentProvisionedResourcesPublisher,
  ListServiceInstanceOutputsPublisher,
  ListRepositoriesPublisher,
  ListTagsForResourcePublisher,
  ListComponentsPublisher,
  ListComponentOutputsPublisher,
  ListEnvironmentTemplateVersionsPublisher,
  ListServiceInstancesPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.proton.model.{
  CreateEnvironmentTemplateVersionRequest,
  GetTemplateSyncConfigRequest,
  DeleteEnvironmentTemplateVersionRequest,
  GetEnvironmentRequest,
  GetEnvironmentAccountConnectionRequest,
  ListServiceInstancesRequest,
  UpdateServicePipelineRequest,
  UpdateAccountSettingsRequest,
  ListEnvironmentsRequest,
  DeleteServiceRequest,
  DeleteEnvironmentTemplateRequest,
  DeleteEnvironmentAccountConnectionRequest,
  GetResourcesSummaryRequest,
  CreateServiceTemplateVersionRequest,
  GetServiceTemplateRequest,
  ListEnvironmentOutputsRequest,
  ListServicePipelineProvisionedResourcesRequest,
  ListRepositorySyncDefinitionsRequest,
  GetRepositorySyncStatusRequest,
  UpdateEnvironmentRequest,
  DeleteComponentRequest,
  ListEnvironmentProvisionedResourcesRequest,
  CreateEnvironmentTemplateRequest,
  ListTagsForResourceRequest,
  GetTemplateSyncStatusRequest,
  CreateServiceTemplateRequest,
  ListServiceTemplatesRequest,
  CreateComponentRequest,
  NotifyResourceDeploymentStatusChangeRequest,
  UpdateEnvironmentAccountConnectionRequest,
  CreateEnvironmentAccountConnectionRequest,
  CreateRepositoryRequest,
  DeleteServiceTemplateVersionRequest,
  UpdateServiceInstanceRequest,
  DeleteTemplateSyncConfigRequest,
  ListComponentOutputsRequest,
  CreateServiceRequest,
  CancelComponentDeploymentRequest,
  ListEnvironmentTemplateVersionsRequest,
  RejectEnvironmentAccountConnectionRequest,
  ListServiceInstanceProvisionedResourcesRequest,
  GetEnvironmentTemplateRequest,
  UpdateEnvironmentTemplateVersionRequest,
  ListServiceTemplateVersionsRequest,
  CancelServiceInstanceDeploymentRequest,
  GetEnvironmentTemplateVersionRequest,
  GetServiceTemplateVersionRequest,
  ListServiceInstanceOutputsRequest,
  CreateTemplateSyncConfigRequest,
  DeleteServiceTemplateRequest,
  UpdateEnvironmentTemplateRequest,
  GetServiceRequest,
  UntagResourceRequest,
  ListRepositoriesRequest,
  ListEnvironmentAccountConnectionsRequest,
  UpdateServiceTemplateVersionRequest,
  UpdateComponentRequest,
  ListEnvironmentTemplatesRequest,
  CancelEnvironmentDeploymentRequest,
  ListServicePipelineOutputsRequest,
  ListComponentsRequest,
  ListComponentProvisionedResourcesRequest,
  ListServicesRequest,
  UpdateServiceTemplateRequest,
  CreateEnvironmentRequest,
  AcceptEnvironmentAccountConnectionRequest,
  DeleteEnvironmentRequest,
  GetComponentRequest,
  DeleteRepositoryRequest,
  GetServiceInstanceRequest,
  CancelServicePipelineDeploymentRequest,
  UpdateServiceRequest,
  GetAccountSettingsRequest,
  UpdateTemplateSyncConfigRequest,
  TagResourceRequest,
  GetRepositoryRequest
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.proton.model.{
  CreateComponentResponse,
  ListEnvironmentProvisionedResourcesResponse,
  UpdateComponentResponse,
  DeleteServiceTemplateResponse,
  ServiceInstanceSummary,
  DeleteRepositoryResponse,
  GetServiceResponse,
  ListRepositoriesResponse,
  ProvisionedResource,
  UpdateEnvironmentAccountConnectionResponse,
  CreateRepositoryResponse,
  CancelServicePipelineDeploymentResponse,
  GetEnvironmentAccountConnectionResponse,
  UpdateEnvironmentTemplateVersionResponse,
  ListEnvironmentTemplateVersionsResponse,
  RejectEnvironmentAccountConnectionResponse,
  ServiceTemplateVersionSummary,
  GetEnvironmentResponse,
  AcceptEnvironmentAccountConnectionResponse,
  EnvironmentTemplateVersionSummary,
  GetRepositoryResponse,
  DeleteEnvironmentTemplateVersionResponse,
  ListServicePipelineOutputsResponse,
  GetServiceTemplateResponse,
  GetResourcesSummaryResponse,
  ListEnvironmentOutputsResponse,
  UpdateServiceInstanceResponse,
  Tag,
  DeleteComponentResponse,
  CreateServiceTemplateResponse,
  EnvironmentTemplateSummary,
  ServiceSummary,
  Output,
  UpdateServiceResponse,
  GetComponentResponse,
  ComponentSummary,
  CancelServiceInstanceDeploymentResponse,
  CreateServiceResponse,
  ServiceTemplateSummary,
  DeleteServiceResponse,
  UpdateEnvironmentResponse,
  GetEnvironmentTemplateVersionResponse,
  ListRepositorySyncDefinitionsResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateEnvironmentTemplateVersionResponse,
  ListServicePipelineProvisionedResourcesResponse,
  ListComponentProvisionedResourcesResponse,
  CreateEnvironmentTemplateResponse,
  DeleteTemplateSyncConfigResponse,
  ListEnvironmentTemplatesResponse,
  EnvironmentAccountConnectionSummary,
  CreateServiceTemplateVersionResponse,
  CancelEnvironmentDeploymentResponse,
  UpdateTemplateSyncConfigResponse,
  UpdateServicePipelineResponse,
  UpdateAccountSettingsResponse,
  ListEnvironmentAccountConnectionsResponse,
  GetAccountSettingsResponse,
  CreateEnvironmentAccountConnectionResponse,
  DeleteEnvironmentAccountConnectionResponse,
  ListServiceInstanceOutputsResponse,
  GetServiceInstanceResponse,
  RepositorySummary,
  CancelComponentDeploymentResponse,
  UpdateEnvironmentTemplateResponse,
  ListServiceTemplateVersionsResponse,
  ListServiceInstancesResponse,
  ListComponentsResponse,
  GetRepositorySyncStatusResponse,
  UpdateServiceTemplateVersionResponse,
  ListServiceTemplatesResponse,
  NotifyResourceDeploymentStatusChangeResponse,
  ListComponentOutputsResponse,
  TagResourceResponse,
  GetTemplateSyncStatusResponse,
  GetServiceTemplateVersionResponse,
  DeleteServiceTemplateVersionResponse,
  ListEnvironmentsResponse,
  UpdateServiceTemplateResponse,
  EnvironmentSummary,
  CreateTemplateSyncConfigResponse,
  GetEnvironmentTemplateResponse,
  CreateEnvironmentResponse,
  ListServiceInstanceProvisionedResourcesResponse,
  DeleteEnvironmentResponse,
  DeleteEnvironmentTemplateResponse,
  RepositorySyncDefinition,
  GetTemplateSyncConfigResponse,
  ListServicesResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.proton.{
  ProtonAsyncClientBuilder,
  ProtonAsyncClient
}
import scala.jdk.CollectionConverters._
trait Proton extends AspectSupport[Proton] {
  val api: ProtonAsyncClient
  def deleteEnvironment(
      request: DeleteEnvironmentRequest
  ): IO[AwsError, zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly]
  def cancelServicePipelineDeployment(
      request: CancelServicePipelineDeploymentRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.CancelServicePipelineDeploymentResponse.ReadOnly
  ]
  def updateEnvironmentTemplateVersion(
      request: UpdateEnvironmentTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse.ReadOnly
  ]
  def notifyResourceDeploymentStatusChange(
      request: NotifyResourceDeploymentStatusChangeRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.NotifyResourceDeploymentStatusChangeResponse.ReadOnly
  ]
  def getRepositorySyncStatus(
      request: GetRepositorySyncStatusRequest
  ): IO[AwsError, zio.aws.proton.model.GetRepositorySyncStatusResponse.ReadOnly]
  def updateServiceTemplateVersion(
      request: UpdateServiceTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.UpdateServiceTemplateVersionResponse.ReadOnly
  ]
  def getServiceInstance(
      request: GetServiceInstanceRequest
  ): IO[AwsError, zio.aws.proton.model.GetServiceInstanceResponse.ReadOnly]
  def createService(
      request: CreateServiceRequest
  ): IO[AwsError, zio.aws.proton.model.CreateServiceResponse.ReadOnly]
  def listComponentOutputs(
      request: ListComponentOutputsRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.Output.ReadOnly]
  def listComponentOutputsPaginated(
      request: ListComponentOutputsRequest
  ): IO[AwsError, zio.aws.proton.model.ListComponentOutputsResponse.ReadOnly]
  def createEnvironmentTemplateVersion(
      request: CreateEnvironmentTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.CreateEnvironmentTemplateVersionResponse.ReadOnly
  ]
  def createEnvironmentAccountConnection(
      request: CreateEnvironmentAccountConnectionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.CreateEnvironmentAccountConnectionResponse.ReadOnly
  ]
  def deleteEnvironmentTemplate(request: DeleteEnvironmentTemplateRequest): IO[
    AwsError,
    zio.aws.proton.model.DeleteEnvironmentTemplateResponse.ReadOnly
  ]
  def createEnvironment(
      request: CreateEnvironmentRequest
  ): IO[AwsError, zio.aws.proton.model.CreateEnvironmentResponse.ReadOnly]
  def createServiceTemplate(
      request: CreateServiceTemplateRequest
  ): IO[AwsError, zio.aws.proton.model.CreateServiceTemplateResponse.ReadOnly]
  def cancelEnvironmentDeployment(
      request: CancelEnvironmentDeploymentRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.CancelEnvironmentDeploymentResponse.ReadOnly
  ]
  def getEnvironment(
      request: GetEnvironmentRequest
  ): IO[AwsError, zio.aws.proton.model.GetEnvironmentResponse.ReadOnly]
  def deleteEnvironmentTemplateVersion(
      request: DeleteEnvironmentTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse.ReadOnly
  ]
  def getRepository(
      request: GetRepositoryRequest
  ): IO[AwsError, zio.aws.proton.model.GetRepositoryResponse.ReadOnly]
  def listServiceTemplates(request: ListServiceTemplatesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.proton.model.ServiceTemplateSummary.ReadOnly
  ]
  def listServiceTemplatesPaginated(
      request: ListServiceTemplatesRequest
  ): IO[AwsError, zio.aws.proton.model.ListServiceTemplatesResponse.ReadOnly]
  def cancelComponentDeployment(request: CancelComponentDeploymentRequest): IO[
    AwsError,
    zio.aws.proton.model.CancelComponentDeploymentResponse.ReadOnly
  ]
  def listServiceInstances(request: ListServiceInstancesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.proton.model.ServiceInstanceSummary.ReadOnly
  ]
  def listServiceInstancesPaginated(
      request: ListServiceInstancesRequest
  ): IO[AwsError, zio.aws.proton.model.ListServiceInstancesResponse.ReadOnly]
  def listServiceInstanceOutputs(
      request: ListServiceInstanceOutputsRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.Output.ReadOnly]
  def listServiceInstanceOutputsPaginated(
      request: ListServiceInstanceOutputsRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListServiceInstanceOutputsResponse.ReadOnly
  ]
  def deleteRepository(
      request: DeleteRepositoryRequest
  ): IO[AwsError, zio.aws.proton.model.DeleteRepositoryResponse.ReadOnly]
  def updateServicePipeline(
      request: UpdateServicePipelineRequest
  ): IO[AwsError, zio.aws.proton.model.UpdateServicePipelineResponse.ReadOnly]
  def getResourcesSummary(
      request: GetResourcesSummaryRequest
  ): IO[AwsError, zio.aws.proton.model.GetResourcesSummaryResponse.ReadOnly]
  def createTemplateSyncConfig(request: CreateTemplateSyncConfigRequest): IO[
    AwsError,
    zio.aws.proton.model.CreateTemplateSyncConfigResponse.ReadOnly
  ]
  def deleteService(
      request: DeleteServiceRequest
  ): IO[AwsError, zio.aws.proton.model.DeleteServiceResponse.ReadOnly]
  def listServices(
      request: ListServicesRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.ServiceSummary.ReadOnly]
  def listServicesPaginated(
      request: ListServicesRequest
  ): IO[AwsError, zio.aws.proton.model.ListServicesResponse.ReadOnly]
  def listEnvironmentAccountConnections(
      request: ListEnvironmentAccountConnectionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly
  ]
  def listEnvironmentAccountConnectionsPaginated(
      request: ListEnvironmentAccountConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse.ReadOnly
  ]
  def listServicePipelineOutputs(
      request: ListServicePipelineOutputsRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.Output.ReadOnly]
  def listServicePipelineOutputsPaginated(
      request: ListServicePipelineOutputsRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListServicePipelineOutputsResponse.ReadOnly
  ]
  def listEnvironmentTemplateVersions(
      request: ListEnvironmentTemplateVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly
  ]
  def listEnvironmentTemplateVersionsPaginated(
      request: ListEnvironmentTemplateVersionsRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse.ReadOnly
  ]
  def updateEnvironmentTemplate(request: UpdateEnvironmentTemplateRequest): IO[
    AwsError,
    zio.aws.proton.model.UpdateEnvironmentTemplateResponse.ReadOnly
  ]
  def updateEnvironmentAccountConnection(
      request: UpdateEnvironmentAccountConnectionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.UpdateEnvironmentAccountConnectionResponse.ReadOnly
  ]
  def updateServiceInstance(
      request: UpdateServiceInstanceRequest
  ): IO[AwsError, zio.aws.proton.model.UpdateServiceInstanceResponse.ReadOnly]
  def deleteTemplateSyncConfig(request: DeleteTemplateSyncConfigRequest): IO[
    AwsError,
    zio.aws.proton.model.DeleteTemplateSyncConfigResponse.ReadOnly
  ]
  def createRepository(
      request: CreateRepositoryRequest
  ): IO[AwsError, zio.aws.proton.model.CreateRepositoryResponse.ReadOnly]
  def listComponents(
      request: ListComponentsRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.ComponentSummary.ReadOnly]
  def listComponentsPaginated(
      request: ListComponentsRequest
  ): IO[AwsError, zio.aws.proton.model.ListComponentsResponse.ReadOnly]
  def deleteServiceTemplate(
      request: DeleteServiceTemplateRequest
  ): IO[AwsError, zio.aws.proton.model.DeleteServiceTemplateResponse.ReadOnly]
  def listEnvironments(
      request: ListEnvironmentsRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.EnvironmentSummary.ReadOnly]
  def listEnvironmentsPaginated(
      request: ListEnvironmentsRequest
  ): IO[AwsError, zio.aws.proton.model.ListEnvironmentsResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.proton.model.UntagResourceResponse.ReadOnly]
  def createServiceTemplateVersion(
      request: CreateServiceTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.CreateServiceTemplateVersionResponse.ReadOnly
  ]
  def listRepositorySyncDefinitions(
      request: ListRepositorySyncDefinitionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.proton.model.RepositorySyncDefinition.ReadOnly
  ]
  def listRepositorySyncDefinitionsPaginated(
      request: ListRepositorySyncDefinitionsRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListRepositorySyncDefinitionsResponse.ReadOnly
  ]
  def deleteComponent(
      request: DeleteComponentRequest
  ): IO[AwsError, zio.aws.proton.model.DeleteComponentResponse.ReadOnly]
  def listRepositories(
      request: ListRepositoriesRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.RepositorySummary.ReadOnly]
  def listRepositoriesPaginated(
      request: ListRepositoriesRequest
  ): IO[AwsError, zio.aws.proton.model.ListRepositoriesResponse.ReadOnly]
  def getService(
      request: GetServiceRequest
  ): IO[AwsError, zio.aws.proton.model.GetServiceResponse.ReadOnly]
  def createComponent(
      request: CreateComponentRequest
  ): IO[AwsError, zio.aws.proton.model.CreateComponentResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.proton.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.proton.model.TagResourceResponse.ReadOnly]
  def updateAccountSettings(
      request: UpdateAccountSettingsRequest
  ): IO[AwsError, zio.aws.proton.model.UpdateAccountSettingsResponse.ReadOnly]
  def rejectEnvironmentAccountConnection(
      request: RejectEnvironmentAccountConnectionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.RejectEnvironmentAccountConnectionResponse.ReadOnly
  ]
  def getTemplateSyncConfig(
      request: GetTemplateSyncConfigRequest
  ): IO[AwsError, zio.aws.proton.model.GetTemplateSyncConfigResponse.ReadOnly]
  def updateEnvironment(
      request: UpdateEnvironmentRequest
  ): IO[AwsError, zio.aws.proton.model.UpdateEnvironmentResponse.ReadOnly]
  def getServiceTemplate(
      request: GetServiceTemplateRequest
  ): IO[AwsError, zio.aws.proton.model.GetServiceTemplateResponse.ReadOnly]
  def getTemplateSyncStatus(
      request: GetTemplateSyncStatusRequest
  ): IO[AwsError, zio.aws.proton.model.GetTemplateSyncStatusResponse.ReadOnly]
  def updateService(
      request: UpdateServiceRequest
  ): IO[AwsError, zio.aws.proton.model.UpdateServiceResponse.ReadOnly]
  def getAccountSettings(
      request: GetAccountSettingsRequest
  ): IO[AwsError, zio.aws.proton.model.GetAccountSettingsResponse.ReadOnly]
  def listServiceTemplateVersions(
      request: ListServiceTemplateVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly
  ]
  def listServiceTemplateVersionsPaginated(
      request: ListServiceTemplateVersionsRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListServiceTemplateVersionsResponse.ReadOnly
  ]
  def deleteEnvironmentAccountConnection(
      request: DeleteEnvironmentAccountConnectionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse.ReadOnly
  ]
  def listServicePipelineProvisionedResources(
      request: ListServicePipelineProvisionedResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.ProvisionedResource.ReadOnly]
  def listServicePipelineProvisionedResourcesPaginated(
      request: ListServicePipelineProvisionedResourcesRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse.ReadOnly
  ]
  def deleteServiceTemplateVersion(
      request: DeleteServiceTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.DeleteServiceTemplateVersionResponse.ReadOnly
  ]
  def listComponentProvisionedResources(
      request: ListComponentProvisionedResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.ProvisionedResource.ReadOnly]
  def listComponentProvisionedResourcesPaginated(
      request: ListComponentProvisionedResourcesRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListComponentProvisionedResourcesResponse.ReadOnly
  ]
  def createEnvironmentTemplate(request: CreateEnvironmentTemplateRequest): IO[
    AwsError,
    zio.aws.proton.model.CreateEnvironmentTemplateResponse.ReadOnly
  ]
  def getEnvironmentTemplateVersion(
      request: GetEnvironmentTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.GetEnvironmentTemplateVersionResponse.ReadOnly
  ]
  def listEnvironmentOutputs(
      request: ListEnvironmentOutputsRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.Output.ReadOnly]
  def listEnvironmentOutputsPaginated(
      request: ListEnvironmentOutputsRequest
  ): IO[AwsError, zio.aws.proton.model.ListEnvironmentOutputsResponse.ReadOnly]
  def getEnvironmentTemplate(
      request: GetEnvironmentTemplateRequest
  ): IO[AwsError, ReadOnly]
  def getComponent(
      request: GetComponentRequest
  ): IO[AwsError, zio.aws.proton.model.GetComponentResponse.ReadOnly]
  def updateComponent(
      request: UpdateComponentRequest
  ): IO[AwsError, zio.aws.proton.model.UpdateComponentResponse.ReadOnly]
  def updateTemplateSyncConfig(request: UpdateTemplateSyncConfigRequest): IO[
    AwsError,
    zio.aws.proton.model.UpdateTemplateSyncConfigResponse.ReadOnly
  ]
  def listEnvironmentTemplates(
      request: ListEnvironmentTemplatesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly
  ]
  def listEnvironmentTemplatesPaginated(
      request: ListEnvironmentTemplatesRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListEnvironmentTemplatesResponse.ReadOnly
  ]
  def updateServiceTemplate(
      request: UpdateServiceTemplateRequest
  ): IO[AwsError, zio.aws.proton.model.UpdateServiceTemplateResponse.ReadOnly]
  def listEnvironmentProvisionedResources(
      request: ListEnvironmentProvisionedResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.ProvisionedResource.ReadOnly]
  def listEnvironmentProvisionedResourcesPaginated(
      request: ListEnvironmentProvisionedResourcesRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListEnvironmentProvisionedResourcesResponse.ReadOnly
  ]
  def getServiceTemplateVersion(request: GetServiceTemplateVersionRequest): IO[
    AwsError,
    zio.aws.proton.model.GetServiceTemplateVersionResponse.ReadOnly
  ]
  def listServiceInstanceProvisionedResources(
      request: ListServiceInstanceProvisionedResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.proton.model.ProvisionedResource.ReadOnly]
  def listServiceInstanceProvisionedResourcesPaginated(
      request: ListServiceInstanceProvisionedResourcesRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse.ReadOnly
  ]
  def acceptEnvironmentAccountConnection(
      request: AcceptEnvironmentAccountConnectionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.AcceptEnvironmentAccountConnectionResponse.ReadOnly
  ]
  def cancelServiceInstanceDeployment(
      request: CancelServiceInstanceDeploymentRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.CancelServiceInstanceDeploymentResponse.ReadOnly
  ]
  def getEnvironmentAccountConnection(
      request: GetEnvironmentAccountConnectionRequest
  ): IO[
    AwsError,
    zio.aws.proton.model.GetEnvironmentAccountConnectionResponse.ReadOnly
  ]
}
object Proton {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Proton] = customized(
    identity
  )
  def customized(
      customization: ProtonAsyncClientBuilder => ProtonAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Proton] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ProtonAsyncClientBuilder => ProtonAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Proton] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ProtonAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[ProtonAsyncClient, ProtonAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[ProtonAsyncClient, ProtonAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new ProtonImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class ProtonImpl[R](
      override val api: ProtonAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Proton
      with AwsServiceBase[R] {
    override val serviceName: String = "Proton"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ProtonImpl[R1] = new ProtonImpl(api, newAspect, r)
    def deleteEnvironment(
        request: DeleteEnvironmentRequest
    ): IO[AwsError, zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.DeleteEnvironmentRequest,
        DeleteEnvironmentResponse
      ]("deleteEnvironment", api.deleteEnvironment)(request.buildAwsValue())
        .map(zio.aws.proton.model.DeleteEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def cancelServicePipelineDeployment(
        request: CancelServicePipelineDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.CancelServicePipelineDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentRequest,
      CancelServicePipelineDeploymentResponse
    ]("cancelServicePipelineDeployment", api.cancelServicePipelineDeployment)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.CancelServicePipelineDeploymentResponse.wrap)
      .provideEnvironment(r)
    def updateEnvironmentTemplateVersion(
        request: UpdateEnvironmentTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionRequest,
      UpdateEnvironmentTemplateVersionResponse
    ]("updateEnvironmentTemplateVersion", api.updateEnvironmentTemplateVersion)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def notifyResourceDeploymentStatusChange(
        request: NotifyResourceDeploymentStatusChangeRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.NotifyResourceDeploymentStatusChangeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest,
      NotifyResourceDeploymentStatusChangeResponse
    ](
      "notifyResourceDeploymentStatusChange",
      api.notifyResourceDeploymentStatusChange
    )(request.buildAwsValue())
      .map(
        zio.aws.proton.model.NotifyResourceDeploymentStatusChangeResponse.wrap
      )
      .provideEnvironment(r)
    def getRepositorySyncStatus(request: GetRepositorySyncStatusRequest): IO[
      AwsError,
      zio.aws.proton.model.GetRepositorySyncStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusRequest,
      GetRepositorySyncStatusResponse
    ]("getRepositorySyncStatus", api.getRepositorySyncStatus)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.GetRepositorySyncStatusResponse.wrap)
      .provideEnvironment(r)
    def updateServiceTemplateVersion(
        request: UpdateServiceTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.UpdateServiceTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionRequest,
      UpdateServiceTemplateVersionResponse
    ]("updateServiceTemplateVersion", api.updateServiceTemplateVersion)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.UpdateServiceTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def getServiceInstance(
        request: GetServiceInstanceRequest
    ): IO[AwsError, zio.aws.proton.model.GetServiceInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest,
        GetServiceInstanceResponse
      ]("getServiceInstance", api.getServiceInstance)(request.buildAwsValue())
        .map(zio.aws.proton.model.GetServiceInstanceResponse.wrap)
        .provideEnvironment(r)
    def createService(
        request: CreateServiceRequest
    ): IO[AwsError, zio.aws.proton.model.CreateServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.CreateServiceRequest,
        CreateServiceResponse
      ]("createService", api.createService)(request.buildAwsValue())
        .map(zio.aws.proton.model.CreateServiceResponse.wrap)
        .provideEnvironment(r)
    def listComponentOutputs(request: ListComponentOutputsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.Output.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest,
      Output,
      ListComponentOutputsPublisher
    ]("listComponentOutputs", api.listComponentOutputsPaginator, _.outputs())(
      request.buildAwsValue()
    ).map(item => zio.aws.proton.model.Output.wrap(item)).provideEnvironment(r)
    def listComponentOutputsPaginated(request: ListComponentOutputsRequest): IO[
      AwsError,
      zio.aws.proton.model.ListComponentOutputsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest,
      ListComponentOutputsResponse
    ]("listComponentOutputs", api.listComponentOutputs)(request.buildAwsValue())
      .map(zio.aws.proton.model.ListComponentOutputsResponse.wrap)
      .provideEnvironment(r)
    def createEnvironmentTemplateVersion(
        request: CreateEnvironmentTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.CreateEnvironmentTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateVersionRequest,
      CreateEnvironmentTemplateVersionResponse
    ]("createEnvironmentTemplateVersion", api.createEnvironmentTemplateVersion)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.CreateEnvironmentTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def createEnvironmentAccountConnection(
        request: CreateEnvironmentAccountConnectionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.CreateEnvironmentAccountConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest,
      CreateEnvironmentAccountConnectionResponse
    ](
      "createEnvironmentAccountConnection",
      api.createEnvironmentAccountConnection
    )(request.buildAwsValue())
      .map(zio.aws.proton.model.CreateEnvironmentAccountConnectionResponse.wrap)
      .provideEnvironment(r)
    def deleteEnvironmentTemplate(
        request: DeleteEnvironmentTemplateRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.DeleteEnvironmentTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateRequest,
      DeleteEnvironmentTemplateResponse
    ]("deleteEnvironmentTemplate", api.deleteEnvironmentTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.DeleteEnvironmentTemplateResponse.wrap)
      .provideEnvironment(r)
    def createEnvironment(
        request: CreateEnvironmentRequest
    ): IO[AwsError, zio.aws.proton.model.CreateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest,
        CreateEnvironmentResponse
      ]("createEnvironment", api.createEnvironment)(request.buildAwsValue())
        .map(zio.aws.proton.model.CreateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def createServiceTemplate(request: CreateServiceTemplateRequest): IO[
      AwsError,
      zio.aws.proton.model.CreateServiceTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CreateServiceTemplateRequest,
      CreateServiceTemplateResponse
    ]("createServiceTemplate", api.createServiceTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.CreateServiceTemplateResponse.wrap)
      .provideEnvironment(r)
    def cancelEnvironmentDeployment(
        request: CancelEnvironmentDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.CancelEnvironmentDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentRequest,
      CancelEnvironmentDeploymentResponse
    ]("cancelEnvironmentDeployment", api.cancelEnvironmentDeployment)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.CancelEnvironmentDeploymentResponse.wrap)
      .provideEnvironment(r)
    def getEnvironment(
        request: GetEnvironmentRequest
    ): IO[AwsError, zio.aws.proton.model.GetEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.GetEnvironmentRequest,
        GetEnvironmentResponse
      ]("getEnvironment", api.getEnvironment)(request.buildAwsValue())
        .map(zio.aws.proton.model.GetEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def deleteEnvironmentTemplateVersion(
        request: DeleteEnvironmentTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionRequest,
      DeleteEnvironmentTemplateVersionResponse
    ]("deleteEnvironmentTemplateVersion", api.deleteEnvironmentTemplateVersion)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def getRepository(
        request: GetRepositoryRequest
    ): IO[AwsError, zio.aws.proton.model.GetRepositoryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.GetRepositoryRequest,
        GetRepositoryResponse
      ]("getRepository", api.getRepository)(request.buildAwsValue())
        .map(zio.aws.proton.model.GetRepositoryResponse.wrap)
        .provideEnvironment(r)
    def listServiceTemplates(request: ListServiceTemplatesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.ServiceTemplateSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest,
      ServiceTemplateSummary,
      ListServiceTemplatesPublisher
    ]("listServiceTemplates", api.listServiceTemplatesPaginator, _.templates())(
      request.buildAwsValue()
    ).map(item => zio.aws.proton.model.ServiceTemplateSummary.wrap(item))
      .provideEnvironment(r)
    def listServiceTemplatesPaginated(request: ListServiceTemplatesRequest): IO[
      AwsError,
      zio.aws.proton.model.ListServiceTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListServiceTemplatesRequest,
      ListServiceTemplatesResponse
    ]("listServiceTemplates", api.listServiceTemplates)(request.buildAwsValue())
      .map(zio.aws.proton.model.ListServiceTemplatesResponse.wrap)
      .provideEnvironment(r)
    def cancelComponentDeployment(
        request: CancelComponentDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.CancelComponentDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CancelComponentDeploymentRequest,
      CancelComponentDeploymentResponse
    ]("cancelComponentDeployment", api.cancelComponentDeployment)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.CancelComponentDeploymentResponse.wrap)
      .provideEnvironment(r)
    def listServiceInstances(request: ListServiceInstancesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.ServiceInstanceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest,
      ServiceInstanceSummary,
      ListServiceInstancesPublisher
    ](
      "listServiceInstances",
      api.listServiceInstancesPaginator,
      _.serviceInstances()
    )(request.buildAwsValue())
      .map(item => zio.aws.proton.model.ServiceInstanceSummary.wrap(item))
      .provideEnvironment(r)
    def listServiceInstancesPaginated(request: ListServiceInstancesRequest): IO[
      AwsError,
      zio.aws.proton.model.ListServiceInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest,
      ListServiceInstancesResponse
    ]("listServiceInstances", api.listServiceInstances)(request.buildAwsValue())
      .map(zio.aws.proton.model.ListServiceInstancesResponse.wrap)
      .provideEnvironment(r)
    def listServiceInstanceOutputs(
        request: ListServiceInstanceOutputsRequest
    ): ZStream[Any, AwsError, zio.aws.proton.model.Output.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest,
        Output,
        ListServiceInstanceOutputsPublisher
      ](
        "listServiceInstanceOutputs",
        api.listServiceInstanceOutputsPaginator,
        _.outputs()
      )(request.buildAwsValue())
        .map(item => zio.aws.proton.model.Output.wrap(item))
        .provideEnvironment(r)
    def listServiceInstanceOutputsPaginated(
        request: ListServiceInstanceOutputsRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListServiceInstanceOutputsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest,
      ListServiceInstanceOutputsResponse
    ]("listServiceInstanceOutputs", api.listServiceInstanceOutputs)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.ListServiceInstanceOutputsResponse.wrap)
      .provideEnvironment(r)
    def deleteRepository(
        request: DeleteRepositoryRequest
    ): IO[AwsError, zio.aws.proton.model.DeleteRepositoryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.DeleteRepositoryRequest,
        DeleteRepositoryResponse
      ]("deleteRepository", api.deleteRepository)(request.buildAwsValue())
        .map(zio.aws.proton.model.DeleteRepositoryResponse.wrap)
        .provideEnvironment(r)
    def updateServicePipeline(request: UpdateServicePipelineRequest): IO[
      AwsError,
      zio.aws.proton.model.UpdateServicePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.UpdateServicePipelineRequest,
      UpdateServicePipelineResponse
    ]("updateServicePipeline", api.updateServicePipeline)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.UpdateServicePipelineResponse.wrap)
      .provideEnvironment(r)
    def getResourcesSummary(
        request: GetResourcesSummaryRequest
    ): IO[AwsError, zio.aws.proton.model.GetResourcesSummaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.GetResourcesSummaryRequest,
        GetResourcesSummaryResponse
      ]("getResourcesSummary", api.getResourcesSummary)(request.buildAwsValue())
        .map(zio.aws.proton.model.GetResourcesSummaryResponse.wrap)
        .provideEnvironment(r)
    def createTemplateSyncConfig(request: CreateTemplateSyncConfigRequest): IO[
      AwsError,
      zio.aws.proton.model.CreateTemplateSyncConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigRequest,
      CreateTemplateSyncConfigResponse
    ]("createTemplateSyncConfig", api.createTemplateSyncConfig)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.CreateTemplateSyncConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteService(
        request: DeleteServiceRequest
    ): IO[AwsError, zio.aws.proton.model.DeleteServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.DeleteServiceRequest,
        DeleteServiceResponse
      ]("deleteService", api.deleteService)(request.buildAwsValue())
        .map(zio.aws.proton.model.DeleteServiceResponse.wrap)
        .provideEnvironment(r)
    def listServices(
        request: ListServicesRequest
    ): ZStream[Any, AwsError, zio.aws.proton.model.ServiceSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.proton.model.ListServicesRequest,
        ServiceSummary,
        ListServicesPublisher
      ]("listServices", api.listServicesPaginator, _.services())(
        request.buildAwsValue()
      ).map(item => zio.aws.proton.model.ServiceSummary.wrap(item))
        .provideEnvironment(r)
    def listServicesPaginated(
        request: ListServicesRequest
    ): IO[AwsError, zio.aws.proton.model.ListServicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.ListServicesRequest,
        ListServicesResponse
      ]("listServices", api.listServices)(request.buildAwsValue())
        .map(zio.aws.proton.model.ListServicesResponse.wrap)
        .provideEnvironment(r)
    def listEnvironmentAccountConnections(
        request: ListEnvironmentAccountConnectionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest,
      EnvironmentAccountConnectionSummary,
      ListEnvironmentAccountConnectionsPublisher
    ](
      "listEnvironmentAccountConnections",
      api.listEnvironmentAccountConnectionsPaginator,
      _.environmentAccountConnections()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.proton.model.EnvironmentAccountConnectionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listEnvironmentAccountConnectionsPaginated(
        request: ListEnvironmentAccountConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest,
      ListEnvironmentAccountConnectionsResponse
    ](
      "listEnvironmentAccountConnections",
      api.listEnvironmentAccountConnections
    )(request.buildAwsValue())
      .map(zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse.wrap)
      .provideEnvironment(r)
    def listServicePipelineOutputs(
        request: ListServicePipelineOutputsRequest
    ): ZStream[Any, AwsError, zio.aws.proton.model.Output.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest,
        Output,
        ListServicePipelineOutputsPublisher
      ](
        "listServicePipelineOutputs",
        api.listServicePipelineOutputsPaginator,
        _.outputs()
      )(request.buildAwsValue())
        .map(item => zio.aws.proton.model.Output.wrap(item))
        .provideEnvironment(r)
    def listServicePipelineOutputsPaginated(
        request: ListServicePipelineOutputsRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListServicePipelineOutputsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest,
      ListServicePipelineOutputsResponse
    ]("listServicePipelineOutputs", api.listServicePipelineOutputs)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.ListServicePipelineOutputsResponse.wrap)
      .provideEnvironment(r)
    def listEnvironmentTemplateVersions(
        request: ListEnvironmentTemplateVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest,
      EnvironmentTemplateVersionSummary,
      ListEnvironmentTemplateVersionsPublisher
    ](
      "listEnvironmentTemplateVersions",
      api.listEnvironmentTemplateVersionsPaginator,
      _.templateVersions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.proton.model.EnvironmentTemplateVersionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listEnvironmentTemplateVersionsPaginated(
        request: ListEnvironmentTemplateVersionsRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest,
      ListEnvironmentTemplateVersionsResponse
    ]("listEnvironmentTemplateVersions", api.listEnvironmentTemplateVersions)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse.wrap)
      .provideEnvironment(r)
    def updateEnvironmentTemplate(
        request: UpdateEnvironmentTemplateRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.UpdateEnvironmentTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest,
      UpdateEnvironmentTemplateResponse
    ]("updateEnvironmentTemplate", api.updateEnvironmentTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.UpdateEnvironmentTemplateResponse.wrap)
      .provideEnvironment(r)
    def updateEnvironmentAccountConnection(
        request: UpdateEnvironmentAccountConnectionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.UpdateEnvironmentAccountConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest,
      UpdateEnvironmentAccountConnectionResponse
    ](
      "updateEnvironmentAccountConnection",
      api.updateEnvironmentAccountConnection
    )(request.buildAwsValue())
      .map(zio.aws.proton.model.UpdateEnvironmentAccountConnectionResponse.wrap)
      .provideEnvironment(r)
    def updateServiceInstance(request: UpdateServiceInstanceRequest): IO[
      AwsError,
      zio.aws.proton.model.UpdateServiceInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.UpdateServiceInstanceRequest,
      UpdateServiceInstanceResponse
    ]("updateServiceInstance", api.updateServiceInstance)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.UpdateServiceInstanceResponse.wrap)
      .provideEnvironment(r)
    def deleteTemplateSyncConfig(request: DeleteTemplateSyncConfigRequest): IO[
      AwsError,
      zio.aws.proton.model.DeleteTemplateSyncConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigRequest,
      DeleteTemplateSyncConfigResponse
    ]("deleteTemplateSyncConfig", api.deleteTemplateSyncConfig)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.DeleteTemplateSyncConfigResponse.wrap)
      .provideEnvironment(r)
    def createRepository(
        request: CreateRepositoryRequest
    ): IO[AwsError, zio.aws.proton.model.CreateRepositoryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.CreateRepositoryRequest,
        CreateRepositoryResponse
      ]("createRepository", api.createRepository)(request.buildAwsValue())
        .map(zio.aws.proton.model.CreateRepositoryResponse.wrap)
        .provideEnvironment(r)
    def listComponents(
        request: ListComponentsRequest
    ): ZStream[Any, AwsError, zio.aws.proton.model.ComponentSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.proton.model.ListComponentsRequest,
        ComponentSummary,
        ListComponentsPublisher
      ]("listComponents", api.listComponentsPaginator, _.components())(
        request.buildAwsValue()
      ).map(item => zio.aws.proton.model.ComponentSummary.wrap(item))
        .provideEnvironment(r)
    def listComponentsPaginated(
        request: ListComponentsRequest
    ): IO[AwsError, zio.aws.proton.model.ListComponentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.ListComponentsRequest,
        ListComponentsResponse
      ]("listComponents", api.listComponents)(request.buildAwsValue())
        .map(zio.aws.proton.model.ListComponentsResponse.wrap)
        .provideEnvironment(r)
    def deleteServiceTemplate(request: DeleteServiceTemplateRequest): IO[
      AwsError,
      zio.aws.proton.model.DeleteServiceTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.DeleteServiceTemplateRequest,
      DeleteServiceTemplateResponse
    ]("deleteServiceTemplate", api.deleteServiceTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.DeleteServiceTemplateResponse.wrap)
      .provideEnvironment(r)
    def listEnvironments(request: ListEnvironmentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.EnvironmentSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest,
      EnvironmentSummary,
      ListEnvironmentsPublisher
    ]("listEnvironments", api.listEnvironmentsPaginator, _.environments())(
      request.buildAwsValue()
    ).map(item => zio.aws.proton.model.EnvironmentSummary.wrap(item))
      .provideEnvironment(r)
    def listEnvironmentsPaginated(
        request: ListEnvironmentsRequest
    ): IO[AwsError, zio.aws.proton.model.ListEnvironmentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest,
        ListEnvironmentsResponse
      ]("listEnvironments", api.listEnvironments)(request.buildAwsValue())
        .map(zio.aws.proton.model.ListEnvironmentsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.proton.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.proton.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createServiceTemplateVersion(
        request: CreateServiceTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.CreateServiceTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionRequest,
      CreateServiceTemplateVersionResponse
    ]("createServiceTemplateVersion", api.createServiceTemplateVersion)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.CreateServiceTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def listRepositorySyncDefinitions(
        request: ListRepositorySyncDefinitionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.RepositorySyncDefinition.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest,
      RepositorySyncDefinition,
      ListRepositorySyncDefinitionsPublisher
    ](
      "listRepositorySyncDefinitions",
      api.listRepositorySyncDefinitionsPaginator,
      _.syncDefinitions()
    )(request.buildAwsValue())
      .map(item => zio.aws.proton.model.RepositorySyncDefinition.wrap(item))
      .provideEnvironment(r)
    def listRepositorySyncDefinitionsPaginated(
        request: ListRepositorySyncDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListRepositorySyncDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest,
      ListRepositorySyncDefinitionsResponse
    ]("listRepositorySyncDefinitions", api.listRepositorySyncDefinitions)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.ListRepositorySyncDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def deleteComponent(
        request: DeleteComponentRequest
    ): IO[AwsError, zio.aws.proton.model.DeleteComponentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.DeleteComponentRequest,
        DeleteComponentResponse
      ]("deleteComponent", api.deleteComponent)(request.buildAwsValue())
        .map(zio.aws.proton.model.DeleteComponentResponse.wrap)
        .provideEnvironment(r)
    def listRepositories(
        request: ListRepositoriesRequest
    ): ZStream[Any, AwsError, zio.aws.proton.model.RepositorySummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.proton.model.ListRepositoriesRequest,
        RepositorySummary,
        ListRepositoriesPublisher
      ]("listRepositories", api.listRepositoriesPaginator, _.repositories())(
        request.buildAwsValue()
      ).map(item => zio.aws.proton.model.RepositorySummary.wrap(item))
        .provideEnvironment(r)
    def listRepositoriesPaginated(
        request: ListRepositoriesRequest
    ): IO[AwsError, zio.aws.proton.model.ListRepositoriesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.ListRepositoriesRequest,
        ListRepositoriesResponse
      ]("listRepositories", api.listRepositories)(request.buildAwsValue())
        .map(zio.aws.proton.model.ListRepositoriesResponse.wrap)
        .provideEnvironment(r)
    def getService(
        request: GetServiceRequest
    ): IO[AwsError, zio.aws.proton.model.GetServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.GetServiceRequest,
        GetServiceResponse
      ]("getService", api.getService)(request.buildAwsValue())
        .map(zio.aws.proton.model.GetServiceResponse.wrap)
        .provideEnvironment(r)
    def createComponent(
        request: CreateComponentRequest
    ): IO[AwsError, zio.aws.proton.model.CreateComponentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.CreateComponentRequest,
        CreateComponentResponse
      ]("createComponent", api.createComponent)(request.buildAwsValue())
        .map(zio.aws.proton.model.CreateComponentResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.proton.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest,
        Tag,
        ListTagsForResourcePublisher
      ]("listTagsForResource", api.listTagsForResourcePaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.proton.model.Tag.wrap(item)).provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.proton.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.proton.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.proton.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.proton.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateAccountSettings(request: UpdateAccountSettingsRequest): IO[
      AwsError,
      zio.aws.proton.model.UpdateAccountSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest,
      UpdateAccountSettingsResponse
    ]("updateAccountSettings", api.updateAccountSettings)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.UpdateAccountSettingsResponse.wrap)
      .provideEnvironment(r)
    def rejectEnvironmentAccountConnection(
        request: RejectEnvironmentAccountConnectionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.RejectEnvironmentAccountConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionRequest,
      RejectEnvironmentAccountConnectionResponse
    ](
      "rejectEnvironmentAccountConnection",
      api.rejectEnvironmentAccountConnection
    )(request.buildAwsValue())
      .map(zio.aws.proton.model.RejectEnvironmentAccountConnectionResponse.wrap)
      .provideEnvironment(r)
    def getTemplateSyncConfig(request: GetTemplateSyncConfigRequest): IO[
      AwsError,
      zio.aws.proton.model.GetTemplateSyncConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigRequest,
      GetTemplateSyncConfigResponse
    ]("getTemplateSyncConfig", api.getTemplateSyncConfig)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.GetTemplateSyncConfigResponse.wrap)
      .provideEnvironment(r)
    def updateEnvironment(
        request: UpdateEnvironmentRequest
    ): IO[AwsError, zio.aws.proton.model.UpdateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest,
        UpdateEnvironmentResponse
      ]("updateEnvironment", api.updateEnvironment)(request.buildAwsValue())
        .map(zio.aws.proton.model.UpdateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def getServiceTemplate(
        request: GetServiceTemplateRequest
    ): IO[AwsError, zio.aws.proton.model.GetServiceTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.GetServiceTemplateRequest,
        GetServiceTemplateResponse
      ]("getServiceTemplate", api.getServiceTemplate)(request.buildAwsValue())
        .map(zio.aws.proton.model.GetServiceTemplateResponse.wrap)
        .provideEnvironment(r)
    def getTemplateSyncStatus(request: GetTemplateSyncStatusRequest): IO[
      AwsError,
      zio.aws.proton.model.GetTemplateSyncStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusRequest,
      GetTemplateSyncStatusResponse
    ]("getTemplateSyncStatus", api.getTemplateSyncStatus)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.GetTemplateSyncStatusResponse.wrap)
      .provideEnvironment(r)
    def updateService(
        request: UpdateServiceRequest
    ): IO[AwsError, zio.aws.proton.model.UpdateServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.UpdateServiceRequest,
        UpdateServiceResponse
      ]("updateService", api.updateService)(request.buildAwsValue())
        .map(zio.aws.proton.model.UpdateServiceResponse.wrap)
        .provideEnvironment(r)
    def getAccountSettings(
        request: GetAccountSettingsRequest
    ): IO[AwsError, zio.aws.proton.model.GetAccountSettingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.GetAccountSettingsRequest,
        GetAccountSettingsResponse
      ]("getAccountSettings", api.getAccountSettings)(request.buildAwsValue())
        .map(zio.aws.proton.model.GetAccountSettingsResponse.wrap)
        .provideEnvironment(r)
    def listServiceTemplateVersions(
        request: ListServiceTemplateVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest,
      ServiceTemplateVersionSummary,
      ListServiceTemplateVersionsPublisher
    ](
      "listServiceTemplateVersions",
      api.listServiceTemplateVersionsPaginator,
      _.templateVersions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.proton.model.ServiceTemplateVersionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listServiceTemplateVersionsPaginated(
        request: ListServiceTemplateVersionsRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListServiceTemplateVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest,
      ListServiceTemplateVersionsResponse
    ]("listServiceTemplateVersions", api.listServiceTemplateVersions)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.ListServiceTemplateVersionsResponse.wrap)
      .provideEnvironment(r)
    def deleteEnvironmentAccountConnection(
        request: DeleteEnvironmentAccountConnectionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionRequest,
      DeleteEnvironmentAccountConnectionResponse
    ](
      "deleteEnvironmentAccountConnection",
      api.deleteEnvironmentAccountConnection
    )(request.buildAwsValue())
      .map(zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse.wrap)
      .provideEnvironment(r)
    def listServicePipelineProvisionedResources(
        request: ListServicePipelineProvisionedResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.ProvisionedResource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest,
      ProvisionedResource,
      ListServicePipelineProvisionedResourcesPublisher
    ](
      "listServicePipelineProvisionedResources",
      api.listServicePipelineProvisionedResourcesPaginator,
      _.provisionedResources()
    )(request.buildAwsValue())
      .map(item => zio.aws.proton.model.ProvisionedResource.wrap(item))
      .provideEnvironment(r)
    def listServicePipelineProvisionedResourcesPaginated(
        request: ListServicePipelineProvisionedResourcesRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest,
      ListServicePipelineProvisionedResourcesResponse
    ](
      "listServicePipelineProvisionedResources",
      api.listServicePipelineProvisionedResources
    )(request.buildAwsValue())
      .map(
        zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse.wrap
      )
      .provideEnvironment(r)
    def deleteServiceTemplateVersion(
        request: DeleteServiceTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.DeleteServiceTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionRequest,
      DeleteServiceTemplateVersionResponse
    ]("deleteServiceTemplateVersion", api.deleteServiceTemplateVersion)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.DeleteServiceTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def listComponentProvisionedResources(
        request: ListComponentProvisionedResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.ProvisionedResource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest,
      ProvisionedResource,
      ListComponentProvisionedResourcesPublisher
    ](
      "listComponentProvisionedResources",
      api.listComponentProvisionedResourcesPaginator,
      _.provisionedResources()
    )(request.buildAwsValue())
      .map(item => zio.aws.proton.model.ProvisionedResource.wrap(item))
      .provideEnvironment(r)
    def listComponentProvisionedResourcesPaginated(
        request: ListComponentProvisionedResourcesRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListComponentProvisionedResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest,
      ListComponentProvisionedResourcesResponse
    ](
      "listComponentProvisionedResources",
      api.listComponentProvisionedResources
    )(request.buildAwsValue())
      .map(zio.aws.proton.model.ListComponentProvisionedResourcesResponse.wrap)
      .provideEnvironment(r)
    def createEnvironmentTemplate(
        request: CreateEnvironmentTemplateRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.CreateEnvironmentTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateRequest,
      CreateEnvironmentTemplateResponse
    ]("createEnvironmentTemplate", api.createEnvironmentTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.CreateEnvironmentTemplateResponse.wrap)
      .provideEnvironment(r)
    def getEnvironmentTemplateVersion(
        request: GetEnvironmentTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.GetEnvironmentTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest,
      GetEnvironmentTemplateVersionResponse
    ]("getEnvironmentTemplateVersion", api.getEnvironmentTemplateVersion)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.GetEnvironmentTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def listEnvironmentOutputs(request: ListEnvironmentOutputsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.Output.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest,
      Output,
      ListEnvironmentOutputsPublisher
    ](
      "listEnvironmentOutputs",
      api.listEnvironmentOutputsPaginator,
      _.outputs()
    )(request.buildAwsValue())
      .map(item => zio.aws.proton.model.Output.wrap(item))
      .provideEnvironment(r)
    def listEnvironmentOutputsPaginated(
        request: ListEnvironmentOutputsRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListEnvironmentOutputsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest,
      ListEnvironmentOutputsResponse
    ]("listEnvironmentOutputs", api.listEnvironmentOutputs)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.ListEnvironmentOutputsResponse.wrap)
      .provideEnvironment(r)
    def getEnvironmentTemplate(
        request: GetEnvironmentTemplateRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateRequest,
      GetEnvironmentTemplateResponse
    ]("getEnvironmentTemplate", api.getEnvironmentTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.GetEnvironmentTemplateResponse.wrap)
      .provideEnvironment(r)
    def getComponent(
        request: GetComponentRequest
    ): IO[AwsError, zio.aws.proton.model.GetComponentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.GetComponentRequest,
        GetComponentResponse
      ]("getComponent", api.getComponent)(request.buildAwsValue())
        .map(zio.aws.proton.model.GetComponentResponse.wrap)
        .provideEnvironment(r)
    def updateComponent(
        request: UpdateComponentRequest
    ): IO[AwsError, zio.aws.proton.model.UpdateComponentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.proton.model.UpdateComponentRequest,
        UpdateComponentResponse
      ]("updateComponent", api.updateComponent)(request.buildAwsValue())
        .map(zio.aws.proton.model.UpdateComponentResponse.wrap)
        .provideEnvironment(r)
    def updateTemplateSyncConfig(request: UpdateTemplateSyncConfigRequest): IO[
      AwsError,
      zio.aws.proton.model.UpdateTemplateSyncConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigRequest,
      UpdateTemplateSyncConfigResponse
    ]("updateTemplateSyncConfig", api.updateTemplateSyncConfig)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.UpdateTemplateSyncConfigResponse.wrap)
      .provideEnvironment(r)
    def listEnvironmentTemplates(
        request: ListEnvironmentTemplatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest,
      EnvironmentTemplateSummary,
      ListEnvironmentTemplatesPublisher
    ](
      "listEnvironmentTemplates",
      api.listEnvironmentTemplatesPaginator,
      _.templates()
    )(request.buildAwsValue())
      .map(item => zio.aws.proton.model.EnvironmentTemplateSummary.wrap(item))
      .provideEnvironment(r)
    def listEnvironmentTemplatesPaginated(
        request: ListEnvironmentTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListEnvironmentTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest,
      ListEnvironmentTemplatesResponse
    ]("listEnvironmentTemplates", api.listEnvironmentTemplates)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.ListEnvironmentTemplatesResponse.wrap)
      .provideEnvironment(r)
    def updateServiceTemplate(request: UpdateServiceTemplateRequest): IO[
      AwsError,
      zio.aws.proton.model.UpdateServiceTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.UpdateServiceTemplateRequest,
      UpdateServiceTemplateResponse
    ]("updateServiceTemplate", api.updateServiceTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.UpdateServiceTemplateResponse.wrap)
      .provideEnvironment(r)
    def listEnvironmentProvisionedResources(
        request: ListEnvironmentProvisionedResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.ProvisionedResource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest,
      ProvisionedResource,
      ListEnvironmentProvisionedResourcesPublisher
    ](
      "listEnvironmentProvisionedResources",
      api.listEnvironmentProvisionedResourcesPaginator,
      _.provisionedResources()
    )(request.buildAwsValue())
      .map(item => zio.aws.proton.model.ProvisionedResource.wrap(item))
      .provideEnvironment(r)
    def listEnvironmentProvisionedResourcesPaginated(
        request: ListEnvironmentProvisionedResourcesRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListEnvironmentProvisionedResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest,
      ListEnvironmentProvisionedResourcesResponse
    ](
      "listEnvironmentProvisionedResources",
      api.listEnvironmentProvisionedResources
    )(request.buildAwsValue())
      .map(
        zio.aws.proton.model.ListEnvironmentProvisionedResourcesResponse.wrap
      )
      .provideEnvironment(r)
    def getServiceTemplateVersion(
        request: GetServiceTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.GetServiceTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionRequest,
      GetServiceTemplateVersionResponse
    ]("getServiceTemplateVersion", api.getServiceTemplateVersion)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.GetServiceTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def listServiceInstanceProvisionedResources(
        request: ListServiceInstanceProvisionedResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.proton.model.ProvisionedResource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest,
      ProvisionedResource,
      ListServiceInstanceProvisionedResourcesPublisher
    ](
      "listServiceInstanceProvisionedResources",
      api.listServiceInstanceProvisionedResourcesPaginator,
      _.provisionedResources()
    )(request.buildAwsValue())
      .map(item => zio.aws.proton.model.ProvisionedResource.wrap(item))
      .provideEnvironment(r)
    def listServiceInstanceProvisionedResourcesPaginated(
        request: ListServiceInstanceProvisionedResourcesRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest,
      ListServiceInstanceProvisionedResourcesResponse
    ](
      "listServiceInstanceProvisionedResources",
      api.listServiceInstanceProvisionedResources
    )(request.buildAwsValue())
      .map(
        zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse.wrap
      )
      .provideEnvironment(r)
    def acceptEnvironmentAccountConnection(
        request: AcceptEnvironmentAccountConnectionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.AcceptEnvironmentAccountConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionRequest,
      AcceptEnvironmentAccountConnectionResponse
    ](
      "acceptEnvironmentAccountConnection",
      api.acceptEnvironmentAccountConnection
    )(request.buildAwsValue())
      .map(zio.aws.proton.model.AcceptEnvironmentAccountConnectionResponse.wrap)
      .provideEnvironment(r)
    def cancelServiceInstanceDeployment(
        request: CancelServiceInstanceDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.CancelServiceInstanceDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.CancelServiceInstanceDeploymentRequest,
      CancelServiceInstanceDeploymentResponse
    ]("cancelServiceInstanceDeployment", api.cancelServiceInstanceDeployment)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.CancelServiceInstanceDeploymentResponse.wrap)
      .provideEnvironment(r)
    def getEnvironmentAccountConnection(
        request: GetEnvironmentAccountConnectionRequest
    ): IO[
      AwsError,
      zio.aws.proton.model.GetEnvironmentAccountConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionRequest,
      GetEnvironmentAccountConnectionResponse
    ]("getEnvironmentAccountConnection", api.getEnvironmentAccountConnection)(
      request.buildAwsValue()
    ).map(zio.aws.proton.model.GetEnvironmentAccountConnectionResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteEnvironment(request: DeleteEnvironmentRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironment(request))
  def cancelServicePipelineDeployment(
      request: CancelServicePipelineDeploymentRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CancelServicePipelineDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelServicePipelineDeployment(request))
  def updateEnvironmentTemplateVersion(
      request: UpdateEnvironmentTemplateVersionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironmentTemplateVersion(request))
  def notifyResourceDeploymentStatusChange(
      request: NotifyResourceDeploymentStatusChangeRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.NotifyResourceDeploymentStatusChangeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.notifyResourceDeploymentStatusChange(request))
  def getRepositorySyncStatus(request: GetRepositorySyncStatusRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetRepositorySyncStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRepositorySyncStatus(request))
  def updateServiceTemplateVersion(
      request: UpdateServiceTemplateVersionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateServiceTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServiceTemplateVersion(request))
  def getServiceInstance(request: GetServiceInstanceRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetServiceInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceInstance(request))
  def createService(request: CreateServiceRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createService(request))
  def listComponentOutputs(request: ListComponentOutputsRequest): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.Output.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponentOutputs(request))
  def listComponentOutputsPaginated(request: ListComponentOutputsRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListComponentOutputsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentOutputsPaginated(request))
  def createEnvironmentTemplateVersion(
      request: CreateEnvironmentTemplateVersionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateEnvironmentTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironmentTemplateVersion(request))
  def createEnvironmentAccountConnection(
      request: CreateEnvironmentAccountConnectionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateEnvironmentAccountConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironmentAccountConnection(request))
  def deleteEnvironmentTemplate(request: DeleteEnvironmentTemplateRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteEnvironmentTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironmentTemplate(request))
  def createEnvironment(request: CreateEnvironmentRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironment(request))
  def createServiceTemplate(request: CreateServiceTemplateRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateServiceTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServiceTemplate(request))
  def cancelEnvironmentDeployment(
      request: CancelEnvironmentDeploymentRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CancelEnvironmentDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelEnvironmentDeployment(request))
  def getEnvironment(request: GetEnvironmentRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironment(request))
  def deleteEnvironmentTemplateVersion(
      request: DeleteEnvironmentTemplateVersionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironmentTemplateVersion(request))
  def getRepository(request: GetRepositoryRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRepository(request))
  def listServiceTemplates(request: ListServiceTemplatesRequest): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ServiceTemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listServiceTemplates(request))
  def listServiceTemplatesPaginated(request: ListServiceTemplatesRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListServiceTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceTemplatesPaginated(request))
  def cancelComponentDeployment(request: CancelComponentDeploymentRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CancelComponentDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelComponentDeployment(request))
  def listServiceInstances(request: ListServiceInstancesRequest): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ServiceInstanceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listServiceInstances(request))
  def listServiceInstancesPaginated(request: ListServiceInstancesRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListServiceInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceInstancesPaginated(request))
  def listServiceInstanceOutputs(
      request: ListServiceInstanceOutputsRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.Output.ReadOnly
  ] = ZStream.serviceWithStream(_.listServiceInstanceOutputs(request))
  def listServiceInstanceOutputsPaginated(
      request: ListServiceInstanceOutputsRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListServiceInstanceOutputsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceInstanceOutputsPaginated(request))
  def deleteRepository(request: DeleteRepositoryRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRepository(request))
  def updateServicePipeline(request: UpdateServicePipelineRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateServicePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServicePipeline(request))
  def getResourcesSummary(request: GetResourcesSummaryRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetResourcesSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcesSummary(request))
  def createTemplateSyncConfig(request: CreateTemplateSyncConfigRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateTemplateSyncConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTemplateSyncConfig(request))
  def deleteService(request: DeleteServiceRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteService(request))
  def listServices(request: ListServicesRequest): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ServiceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listServices(request))
  def listServicesPaginated(request: ListServicesRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServicesPaginated(request))
  def listEnvironmentAccountConnections(
      request: ListEnvironmentAccountConnectionsRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironmentAccountConnections(request))
  def listEnvironmentAccountConnectionsPaginated(
      request: ListEnvironmentAccountConnectionsRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentAccountConnectionsPaginated(request))
  def listServicePipelineOutputs(
      request: ListServicePipelineOutputsRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.Output.ReadOnly
  ] = ZStream.serviceWithStream(_.listServicePipelineOutputs(request))
  def listServicePipelineOutputsPaginated(
      request: ListServicePipelineOutputsRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListServicePipelineOutputsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServicePipelineOutputsPaginated(request))
  def listEnvironmentTemplateVersions(
      request: ListEnvironmentTemplateVersionsRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironmentTemplateVersions(request))
  def listEnvironmentTemplateVersionsPaginated(
      request: ListEnvironmentTemplateVersionsRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentTemplateVersionsPaginated(request))
  def updateEnvironmentTemplate(request: UpdateEnvironmentTemplateRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateEnvironmentTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironmentTemplate(request))
  def updateEnvironmentAccountConnection(
      request: UpdateEnvironmentAccountConnectionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateEnvironmentAccountConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironmentAccountConnection(request))
  def updateServiceInstance(request: UpdateServiceInstanceRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateServiceInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServiceInstance(request))
  def deleteTemplateSyncConfig(request: DeleteTemplateSyncConfigRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteTemplateSyncConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTemplateSyncConfig(request))
  def createRepository(request: CreateRepositoryRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRepository(request))
  def listComponents(request: ListComponentsRequest): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ComponentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponents(request))
  def listComponentsPaginated(request: ListComponentsRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentsPaginated(request))
  def deleteServiceTemplate(request: DeleteServiceTemplateRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteServiceTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServiceTemplate(request))
  def listEnvironments(request: ListEnvironmentsRequest): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.EnvironmentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironments(request))
  def listEnvironmentsPaginated(request: ListEnvironmentsRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentsPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createServiceTemplateVersion(
      request: CreateServiceTemplateVersionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateServiceTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServiceTemplateVersion(request))
  def listRepositorySyncDefinitions(
      request: ListRepositorySyncDefinitionsRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.RepositorySyncDefinition.ReadOnly
  ] = ZStream.serviceWithStream(_.listRepositorySyncDefinitions(request))
  def listRepositorySyncDefinitionsPaginated(
      request: ListRepositorySyncDefinitionsRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListRepositorySyncDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRepositorySyncDefinitionsPaginated(request))
  def deleteComponent(request: DeleteComponentRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteComponent(request))
  def listRepositories(request: ListRepositoriesRequest): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.RepositorySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRepositories(request))
  def listRepositoriesPaginated(request: ListRepositoriesRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListRepositoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRepositoriesPaginated(request))
  def getService(request: GetServiceRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getService(request))
  def createComponent(request: CreateComponentRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComponent(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateAccountSettings(request: UpdateAccountSettingsRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateAccountSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccountSettings(request))
  def rejectEnvironmentAccountConnection(
      request: RejectEnvironmentAccountConnectionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.RejectEnvironmentAccountConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectEnvironmentAccountConnection(request))
  def getTemplateSyncConfig(request: GetTemplateSyncConfigRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetTemplateSyncConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemplateSyncConfig(request))
  def updateEnvironment(request: UpdateEnvironmentRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironment(request))
  def getServiceTemplate(request: GetServiceTemplateRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetServiceTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceTemplate(request))
  def getTemplateSyncStatus(request: GetTemplateSyncStatusRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetTemplateSyncStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemplateSyncStatus(request))
  def updateService(request: UpdateServiceRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateService(request))
  def getAccountSettings(request: GetAccountSettingsRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetAccountSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountSettings(request))
  def listServiceTemplateVersions(
      request: ListServiceTemplateVersionsRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listServiceTemplateVersions(request))
  def listServiceTemplateVersionsPaginated(
      request: ListServiceTemplateVersionsRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListServiceTemplateVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceTemplateVersionsPaginated(request))
  def deleteEnvironmentAccountConnection(
      request: DeleteEnvironmentAccountConnectionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteEnvironmentAccountConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironmentAccountConnection(request))
  def listServicePipelineProvisionedResources(
      request: ListServicePipelineProvisionedResourcesRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ProvisionedResource.ReadOnly
  ] = ZStream.serviceWithStream(
    _.listServicePipelineProvisionedResources(request)
  )
  def listServicePipelineProvisionedResourcesPaginated(
      request: ListServicePipelineProvisionedResourcesRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListServicePipelineProvisionedResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listServicePipelineProvisionedResourcesPaginated(request)
  )
  def deleteServiceTemplateVersion(
      request: DeleteServiceTemplateVersionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.DeleteServiceTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServiceTemplateVersion(request))
  def listComponentProvisionedResources(
      request: ListComponentProvisionedResourcesRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ProvisionedResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponentProvisionedResources(request))
  def listComponentProvisionedResourcesPaginated(
      request: ListComponentProvisionedResourcesRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListComponentProvisionedResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentProvisionedResourcesPaginated(request))
  def createEnvironmentTemplate(request: CreateEnvironmentTemplateRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CreateEnvironmentTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironmentTemplate(request))
  def getEnvironmentTemplateVersion(
      request: GetEnvironmentTemplateVersionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetEnvironmentTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironmentTemplateVersion(request))
  def listEnvironmentOutputs(request: ListEnvironmentOutputsRequest): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.Output.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironmentOutputs(request))
  def listEnvironmentOutputsPaginated(
      request: ListEnvironmentOutputsRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListEnvironmentOutputsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentOutputsPaginated(request))
  def getEnvironmentTemplate(
      request: GetEnvironmentTemplateRequest
  ): ZIO[zio.aws.proton.Proton, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getEnvironmentTemplate(request))
  def getComponent(request: GetComponentRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComponent(request))
  def updateComponent(request: UpdateComponentRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateComponent(request))
  def updateTemplateSyncConfig(request: UpdateTemplateSyncConfigRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateTemplateSyncConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTemplateSyncConfig(request))
  def listEnvironmentTemplates(
      request: ListEnvironmentTemplatesRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironmentTemplates(request))
  def listEnvironmentTemplatesPaginated(
      request: ListEnvironmentTemplatesRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListEnvironmentTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentTemplatesPaginated(request))
  def updateServiceTemplate(request: UpdateServiceTemplateRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.UpdateServiceTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServiceTemplate(request))
  def listEnvironmentProvisionedResources(
      request: ListEnvironmentProvisionedResourcesRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ProvisionedResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironmentProvisionedResources(request))
  def listEnvironmentProvisionedResourcesPaginated(
      request: ListEnvironmentProvisionedResourcesRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListEnvironmentProvisionedResourcesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listEnvironmentProvisionedResourcesPaginated(request))
  def getServiceTemplateVersion(request: GetServiceTemplateVersionRequest): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetServiceTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceTemplateVersion(request))
  def listServiceInstanceProvisionedResources(
      request: ListServiceInstanceProvisionedResourcesRequest
  ): ZStream[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ProvisionedResource.ReadOnly
  ] = ZStream.serviceWithStream(
    _.listServiceInstanceProvisionedResources(request)
  )
  def listServiceInstanceProvisionedResourcesPaginated(
      request: ListServiceInstanceProvisionedResourcesRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listServiceInstanceProvisionedResourcesPaginated(request)
  )
  def acceptEnvironmentAccountConnection(
      request: AcceptEnvironmentAccountConnectionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.AcceptEnvironmentAccountConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptEnvironmentAccountConnection(request))
  def cancelServiceInstanceDeployment(
      request: CancelServiceInstanceDeploymentRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.CancelServiceInstanceDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelServiceInstanceDeployment(request))
  def getEnvironmentAccountConnection(
      request: GetEnvironmentAccountConnectionRequest
  ): ZIO[
    zio.aws.proton.Proton,
    AwsError,
    zio.aws.proton.model.GetEnvironmentAccountConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironmentAccountConnection(request))
}
