package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateComponentResponse(
    component: zio.aws.proton.model.Component
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateComponentResponse = {
    import UpdateComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateComponentResponse
      .builder()
      .component(component.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateComponentResponse.ReadOnly =
    zio.aws.proton.model.UpdateComponentResponse.wrap(buildAwsValue())
}
object UpdateComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateComponentResponse =
      zio.aws.proton.model.UpdateComponentResponse(component.asEditable)
    def component: zio.aws.proton.model.Component.ReadOnly
    def getComponent
        : ZIO[Any, Nothing, zio.aws.proton.model.Component.ReadOnly] =
      ZIO.succeed(component)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateComponentResponse
  ) extends zio.aws.proton.model.UpdateComponentResponse.ReadOnly {
    override val component: zio.aws.proton.model.Component.ReadOnly =
      zio.aws.proton.model.Component.wrap(impl.component())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateComponentResponse
  ): zio.aws.proton.model.UpdateComponentResponse.ReadOnly = new Wrapper(impl)
}
