package zio.aws.proton.model
import zio.aws.proton.model.primitives.{EmptyNextToken, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListComponentOutputsRequest(
    componentName: ResourceName,
    nextToken: Optional[EmptyNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest = {
    import ListComponentOutputsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest
      .builder()
      .componentName(ResourceName.unwrap(componentName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListComponentOutputsRequest.ReadOnly =
    zio.aws.proton.model.ListComponentOutputsRequest.wrap(buildAwsValue())
}
object ListComponentOutputsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListComponentOutputsRequest =
      zio.aws.proton.model.ListComponentOutputsRequest(
        componentName,
        nextToken.map(value => value)
      )
    def componentName: ResourceName
    def nextToken: Optional[EmptyNextToken]
    def getComponentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(componentName)
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest
  ) extends zio.aws.proton.model.ListComponentOutputsRequest.ReadOnly {
    override val componentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.componentName())
    override val nextToken: Optional[EmptyNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest
  ): zio.aws.proton.model.ListComponentOutputsRequest.ReadOnly = new Wrapper(
    impl
  )
}
