package zio.aws.proton.model
import zio.aws.proton.model.primitives.{EnvironmentAccountConnectionId, RoleArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentAccountConnectionRequest(
    codebuildRoleArn: Optional[RoleArn] = Optional.Absent,
    componentRoleArn: Optional[RoleArn] = Optional.Absent,
    id: EnvironmentAccountConnectionId,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest = {
    import UpdateEnvironmentAccountConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
      .builder()
      .optionallyWith(
        codebuildRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.codebuildRoleArn)
      .optionallyWith(
        componentRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.componentRoleArn)
      .id(EnvironmentAccountConnectionId.unwrap(id): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest
      .wrap(buildAwsValue())
}
object UpdateEnvironmentAccountConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest =
      zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest(
        codebuildRoleArn.map(value => value),
        componentRoleArn.map(value => value),
        id,
        roleArn.map(value => value)
      )
    def codebuildRoleArn: Optional[RoleArn]
    def componentRoleArn: Optional[RoleArn]
    def id: EnvironmentAccountConnectionId
    def roleArn: Optional[RoleArn]
    def getCodebuildRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("codebuildRoleArn", codebuildRoleArn)
    def getComponentRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("componentRoleArn", componentRoleArn)
    def getId: ZIO[Any, Nothing, EnvironmentAccountConnectionId] =
      ZIO.succeed(id)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
  ) extends zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest.ReadOnly {
    override val codebuildRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.codebuildRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val componentRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.componentRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val id: EnvironmentAccountConnectionId =
      zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(impl.id())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
  ): zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
