package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, EmptyNextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListServiceInstanceOutputsRequest(
    nextToken: Optional[EmptyNextToken] = Optional.Absent,
    serviceInstanceName: ResourceName,
    serviceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest = {
    import ListServiceInstanceOutputsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serviceInstanceName(
        ResourceName.unwrap(serviceInstanceName): java.lang.String
      )
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListServiceInstanceOutputsRequest.ReadOnly =
    zio.aws.proton.model.ListServiceInstanceOutputsRequest.wrap(buildAwsValue())
}
object ListServiceInstanceOutputsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServiceInstanceOutputsRequest =
      zio.aws.proton.model.ListServiceInstanceOutputsRequest(
        nextToken.map(value => value),
        serviceInstanceName,
        serviceName
      )
    def nextToken: Optional[EmptyNextToken]
    def serviceInstanceName: ResourceName
    def serviceName: ResourceName
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceInstanceName)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest
  ) extends zio.aws.proton.model.ListServiceInstanceOutputsRequest.ReadOnly {
    override val nextToken: Optional[EmptyNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val serviceInstanceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceInstanceName())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest
  ): zio.aws.proton.model.ListServiceInstanceOutputsRequest.ReadOnly =
    new Wrapper(impl)
}
