package zio.aws.proton.model
import zio.aws.proton.model.primitives.RoleArnOrEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountSettings(
    pipelineCodebuildRoleArn: Optional[RoleArnOrEmptyString] = Optional.Absent,
    pipelineProvisioningRepository: Optional[
      zio.aws.proton.model.RepositoryBranch
    ] = Optional.Absent,
    pipelineServiceRoleArn: Optional[RoleArnOrEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.AccountSettings = {
    import AccountSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.AccountSettings
      .builder()
      .optionallyWith(
        pipelineCodebuildRoleArn.map(value =>
          RoleArnOrEmptyString.unwrap(value): java.lang.String
        )
      )(_.pipelineCodebuildRoleArn)
      .optionallyWith(
        pipelineProvisioningRepository.map(value => value.buildAwsValue())
      )(_.pipelineProvisioningRepository)
      .optionallyWith(
        pipelineServiceRoleArn.map(value =>
          RoleArnOrEmptyString.unwrap(value): java.lang.String
        )
      )(_.pipelineServiceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.AccountSettings.ReadOnly =
    zio.aws.proton.model.AccountSettings.wrap(buildAwsValue())
}
object AccountSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.AccountSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.AccountSettings =
      zio.aws.proton.model.AccountSettings(
        pipelineCodebuildRoleArn.map(value => value),
        pipelineProvisioningRepository.map(value => value.asEditable),
        pipelineServiceRoleArn.map(value => value)
      )
    def pipelineCodebuildRoleArn: Optional[RoleArnOrEmptyString]
    def pipelineProvisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranch.ReadOnly]
    def pipelineServiceRoleArn: Optional[RoleArnOrEmptyString]
    def getPipelineCodebuildRoleArn: ZIO[Any, AwsError, RoleArnOrEmptyString] =
      AwsError.unwrapOptionField(
        "pipelineCodebuildRoleArn",
        pipelineCodebuildRoleArn
      )
    def getPipelineProvisioningRepository
        : ZIO[Any, AwsError, zio.aws.proton.model.RepositoryBranch.ReadOnly] =
      AwsError.unwrapOptionField(
        "pipelineProvisioningRepository",
        pipelineProvisioningRepository
      )
    def getPipelineServiceRoleArn: ZIO[Any, AwsError, RoleArnOrEmptyString] =
      AwsError.unwrapOptionField(
        "pipelineServiceRoleArn",
        pipelineServiceRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.AccountSettings
  ) extends zio.aws.proton.model.AccountSettings.ReadOnly {
    override val pipelineCodebuildRoleArn: Optional[RoleArnOrEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineCodebuildRoleArn())
        .map(value =>
          zio.aws.proton.model.primitives.RoleArnOrEmptyString(value)
        )
    override val pipelineProvisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineProvisioningRepository())
        .map(value => zio.aws.proton.model.RepositoryBranch.wrap(value))
    override val pipelineServiceRoleArn: Optional[RoleArnOrEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineServiceRoleArn())
        .map(value =>
          zio.aws.proton.model.primitives.RoleArnOrEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.AccountSettings
  ): zio.aws.proton.model.AccountSettings.ReadOnly = new Wrapper(impl)
}
