package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  EnvironmentAccountConnectionId,
  RoleArn,
  TemplateVersionPart,
  Arn,
  SpecContents,
  Description,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentRequest(
    codebuildRoleArn: Optional[RoleArn] = Optional.Absent,
    componentRoleArn: Optional[RoleArn] = Optional.Absent,
    deploymentType: zio.aws.proton.model.DeploymentUpdateType,
    description: Optional[Description] = Optional.Absent,
    environmentAccountConnectionId: Optional[EnvironmentAccountConnectionId] =
      Optional.Absent,
    name: ResourceName,
    protonServiceRoleArn: Optional[Arn] = Optional.Absent,
    provisioningRepository: Optional[
      zio.aws.proton.model.RepositoryBranchInput
    ] = Optional.Absent,
    spec: Optional[SpecContents] = Optional.Absent,
    templateMajorVersion: Optional[TemplateVersionPart] = Optional.Absent,
    templateMinorVersion: Optional[TemplateVersionPart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest = {
    import UpdateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest
      .builder()
      .optionallyWith(
        codebuildRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.codebuildRoleArn)
      .optionallyWith(
        componentRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.componentRoleArn)
      .deploymentType(deploymentType.unwrap)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentAccountConnectionId.map(value =>
          EnvironmentAccountConnectionId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountConnectionId)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        protonServiceRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.protonServiceRoleArn)
      .optionallyWith(
        provisioningRepository.map(value => value.buildAwsValue())
      )(_.provisioningRepository)
      .optionallyWith(
        spec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.spec)
      .optionallyWith(
        templateMajorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMajorVersion)
      .optionallyWith(
        templateMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMinorVersion)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateEnvironmentRequest.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateEnvironmentRequest =
      zio.aws.proton.model.UpdateEnvironmentRequest(
        codebuildRoleArn.map(value => value),
        componentRoleArn.map(value => value),
        deploymentType,
        description.map(value => value),
        environmentAccountConnectionId.map(value => value),
        name,
        protonServiceRoleArn.map(value => value),
        provisioningRepository.map(value => value.asEditable),
        spec.map(value => value),
        templateMajorVersion.map(value => value),
        templateMinorVersion.map(value => value)
      )
    def codebuildRoleArn: Optional[RoleArn]
    def componentRoleArn: Optional[RoleArn]
    def deploymentType: zio.aws.proton.model.DeploymentUpdateType
    def description: Optional[Description]
    def environmentAccountConnectionId: Optional[EnvironmentAccountConnectionId]
    def name: ResourceName
    def protonServiceRoleArn: Optional[Arn]
    def provisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranchInput.ReadOnly]
    def spec: Optional[SpecContents]
    def templateMajorVersion: Optional[TemplateVersionPart]
    def templateMinorVersion: Optional[TemplateVersionPart]
    def getCodebuildRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("codebuildRoleArn", codebuildRoleArn)
    def getComponentRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("componentRoleArn", componentRoleArn)
    def getDeploymentType
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentUpdateType] =
      ZIO.succeed(deploymentType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentAccountConnectionId
        : ZIO[Any, AwsError, EnvironmentAccountConnectionId] =
      AwsError.unwrapOptionField(
        "environmentAccountConnectionId",
        environmentAccountConnectionId
      )
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getProtonServiceRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("protonServiceRoleArn", protonServiceRoleArn)
    def getProvisioningRepository: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.RepositoryBranchInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningRepository",
      provisioningRepository
    )
    def getSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("spec", spec)
    def getTemplateMajorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMajorVersion", templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMinorVersion", templateMinorVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest
  ) extends zio.aws.proton.model.UpdateEnvironmentRequest.ReadOnly {
    override val codebuildRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.codebuildRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val componentRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.componentRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val deploymentType: zio.aws.proton.model.DeploymentUpdateType =
      zio.aws.proton.model.DeploymentUpdateType.wrap(impl.deploymentType())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val environmentAccountConnectionId
        : Optional[EnvironmentAccountConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentAccountConnectionId())
      .map(value =>
        zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(value)
      )
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val protonServiceRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.protonServiceRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val provisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranchInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningRepository())
        .map(value => zio.aws.proton.model.RepositoryBranchInput.wrap(value))
    override val spec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.spec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
    override val templateMajorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMajorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
    override val templateMinorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMinorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentRequest
  ): zio.aws.proton.model.UpdateEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
