package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRepositoriesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    repositories: Iterable[zio.aws.proton.model.RepositorySummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListRepositoriesResponse = {
    import ListRepositoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListRepositoriesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .repositories(repositories.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListRepositoriesResponse.ReadOnly =
    zio.aws.proton.model.ListRepositoriesResponse.wrap(buildAwsValue())
}
object ListRepositoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListRepositoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListRepositoriesResponse =
      zio.aws.proton.model.ListRepositoriesResponse(
        nextToken.map(value => value),
        repositories.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def repositories: List[zio.aws.proton.model.RepositorySummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRepositories: ZIO[Any, Nothing, List[
      zio.aws.proton.model.RepositorySummary.ReadOnly
    ]] = ZIO.succeed(repositories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListRepositoriesResponse
  ) extends zio.aws.proton.model.ListRepositoriesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val repositories
        : List[zio.aws.proton.model.RepositorySummary.ReadOnly] = impl
      .repositories()
      .asScala
      .map { item =>
        zio.aws.proton.model.RepositorySummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListRepositoriesResponse
  ): zio.aws.proton.model.ListRepositoriesResponse.ReadOnly = new Wrapper(impl)
}
