package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTemplateSyncConfigRequest(
    templateName: ResourceName,
    templateType: zio.aws.proton.model.TemplateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigRequest = {
    import DeleteTemplateSyncConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigRequest
      .builder()
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .templateType(templateType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.DeleteTemplateSyncConfigRequest.ReadOnly =
    zio.aws.proton.model.DeleteTemplateSyncConfigRequest.wrap(buildAwsValue())
}
object DeleteTemplateSyncConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteTemplateSyncConfigRequest =
      zio.aws.proton.model
        .DeleteTemplateSyncConfigRequest(templateName, templateType)
    def templateName: ResourceName
    def templateType: zio.aws.proton.model.TemplateType
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
    def getTemplateType: ZIO[Any, Nothing, zio.aws.proton.model.TemplateType] =
      ZIO.succeed(templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigRequest
  ) extends zio.aws.proton.model.DeleteTemplateSyncConfigRequest.ReadOnly {
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
    override val templateType: zio.aws.proton.model.TemplateType =
      zio.aws.proton.model.TemplateType.wrap(impl.templateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteTemplateSyncConfigRequest
  ): zio.aws.proton.model.DeleteTemplateSyncConfigRequest.ReadOnly =
    new Wrapper(impl)
}
