package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  AwsAccountId,
  ResourceName,
  RoleArn,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentAccountConnectionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    codebuildRoleArn: Optional[RoleArn] = Optional.Absent,
    componentRoleArn: Optional[RoleArn] = Optional.Absent,
    environmentName: ResourceName,
    managementAccountId: AwsAccountId,
    roleArn: Optional[RoleArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.proton.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest = {
    import CreateEnvironmentAccountConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        codebuildRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.codebuildRoleArn)
      .optionallyWith(
        componentRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.componentRoleArn)
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .managementAccountId(
        AwsAccountId.unwrap(managementAccountId): java.lang.String
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest.ReadOnly =
    zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest
      .wrap(buildAwsValue())
}
object CreateEnvironmentAccountConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest =
      zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest(
        clientToken.map(value => value),
        codebuildRoleArn.map(value => value),
        componentRoleArn.map(value => value),
        environmentName,
        managementAccountId,
        roleArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[ClientToken]
    def codebuildRoleArn: Optional[RoleArn]
    def componentRoleArn: Optional[RoleArn]
    def environmentName: ResourceName
    def managementAccountId: AwsAccountId
    def roleArn: Optional[RoleArn]
    def tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCodebuildRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("codebuildRoleArn", codebuildRoleArn)
    def getComponentRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("componentRoleArn", componentRoleArn)
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getManagementAccountId: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(managementAccountId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest
  ) extends zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.proton.model.primitives.ClientToken(value))
    override val codebuildRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.codebuildRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val componentRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.componentRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val managementAccountId: AwsAccountId =
      zio.aws.proton.model.primitives.AwsAccountId(impl.managementAccountId())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentAccountConnectionRequest
  ): zio.aws.proton.model.CreateEnvironmentAccountConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
