package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentResponse(
    environment: zio.aws.proton.model.Environment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentResponse = {
    import UpdateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentResponse
      .builder()
      .environment(environment.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateEnvironmentResponse.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentResponse.wrap(buildAwsValue())
}
object UpdateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateEnvironmentResponse =
      zio.aws.proton.model.UpdateEnvironmentResponse(environment.asEditable)
    def environment: zio.aws.proton.model.Environment.ReadOnly
    def getEnvironment
        : ZIO[Any, Nothing, zio.aws.proton.model.Environment.ReadOnly] =
      ZIO.succeed(environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentResponse
  ) extends zio.aws.proton.model.UpdateEnvironmentResponse.ReadOnly {
    override val environment: zio.aws.proton.model.Environment.ReadOnly =
      zio.aws.proton.model.Environment.wrap(impl.environment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentResponse
  ): zio.aws.proton.model.UpdateEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
