package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEnvironmentTemplateVersionsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    templateVersions: Iterable[
      zio.aws.proton.model.EnvironmentTemplateVersionSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse = {
    import ListEnvironmentTemplateVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templateVersions(templateVersions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse.ReadOnly =
    zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse
      .wrap(buildAwsValue())
}
object ListEnvironmentTemplateVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse =
      zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse(
        nextToken.map(value => value),
        templateVersions.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def templateVersions
        : List[zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplateVersions: ZIO[Any, Nothing, List[
      zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly
    ]] = ZIO.succeed(templateVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse
  ) extends zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val templateVersions: List[
      zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly
    ] = impl
      .templateVersions()
      .asScala
      .map { item =>
        zio.aws.proton.model.EnvironmentTemplateVersionSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse
  ): zio.aws.proton.model.ListEnvironmentTemplateVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
