package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  EnvironmentAccountConnectionId,
  RoleArn,
  TemplateVersionPart,
  EnvironmentArn,
  Timestamp,
  Arn,
  SpecContents,
  Description,
  AwsAccountId,
  StatusMessage,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class Environment(
    arn: EnvironmentArn,
    codebuildRoleArn: Optional[RoleArn] = Optional.Absent,
    componentRoleArn: Optional[RoleArn] = Optional.Absent,
    createdAt: Timestamp,
    deploymentStatus: zio.aws.proton.model.DeploymentStatus,
    deploymentStatusMessage: Optional[StatusMessage] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentAccountConnectionId: Optional[EnvironmentAccountConnectionId] =
      Optional.Absent,
    environmentAccountId: Optional[AwsAccountId] = Optional.Absent,
    lastDeploymentAttemptedAt: Timestamp,
    lastDeploymentSucceededAt: Timestamp,
    name: ResourceName,
    protonServiceRoleArn: Optional[Arn] = Optional.Absent,
    provisioning: Optional[zio.aws.proton.model.Provisioning] = Optional.Absent,
    provisioningRepository: Optional[zio.aws.proton.model.RepositoryBranch] =
      Optional.Absent,
    spec: Optional[SpecContents] = Optional.Absent,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.Environment = {
    import Environment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.Environment
      .builder()
      .arn(EnvironmentArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        codebuildRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.codebuildRoleArn)
      .optionallyWith(
        componentRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.componentRoleArn)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .deploymentStatus(deploymentStatus.unwrap)
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentAccountConnectionId.map(value =>
          EnvironmentAccountConnectionId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountConnectionId)
      .optionallyWith(
        environmentAccountId.map(value =>
          AwsAccountId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountId)
      .lastDeploymentAttemptedAt(
        Timestamp.unwrap(lastDeploymentAttemptedAt): Instant
      )
      .lastDeploymentSucceededAt(
        Timestamp.unwrap(lastDeploymentSucceededAt): Instant
      )
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        protonServiceRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.protonServiceRoleArn)
      .optionallyWith(provisioning.map(value => value.unwrap))(_.provisioning)
      .optionallyWith(
        provisioningRepository.map(value => value.buildAwsValue())
      )(_.provisioningRepository)
      .optionallyWith(
        spec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.spec)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .templateMinorVersion(
        TemplateVersionPart.unwrap(templateMinorVersion): java.lang.String
      )
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.Environment.ReadOnly =
    zio.aws.proton.model.Environment.wrap(buildAwsValue())
}
object Environment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.Environment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.Environment =
      zio.aws.proton.model.Environment(
        arn,
        codebuildRoleArn.map(value => value),
        componentRoleArn.map(value => value),
        createdAt,
        deploymentStatus,
        deploymentStatusMessage.map(value => value),
        description.map(value => value),
        environmentAccountConnectionId.map(value => value),
        environmentAccountId.map(value => value),
        lastDeploymentAttemptedAt,
        lastDeploymentSucceededAt,
        name,
        protonServiceRoleArn.map(value => value),
        provisioning.map(value => value),
        provisioningRepository.map(value => value.asEditable),
        spec.map(value => value),
        templateMajorVersion,
        templateMinorVersion,
        templateName
      )
    def arn: EnvironmentArn
    def codebuildRoleArn: Optional[RoleArn]
    def componentRoleArn: Optional[RoleArn]
    def createdAt: Timestamp
    def deploymentStatus: zio.aws.proton.model.DeploymentStatus
    def deploymentStatusMessage: Optional[StatusMessage]
    def description: Optional[Description]
    def environmentAccountConnectionId: Optional[EnvironmentAccountConnectionId]
    def environmentAccountId: Optional[AwsAccountId]
    def lastDeploymentAttemptedAt: Timestamp
    def lastDeploymentSucceededAt: Timestamp
    def name: ResourceName
    def protonServiceRoleArn: Optional[Arn]
    def provisioning: Optional[zio.aws.proton.model.Provisioning]
    def provisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranch.ReadOnly]
    def spec: Optional[SpecContents]
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, EnvironmentArn] = ZIO.succeed(arn)
    def getCodebuildRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("codebuildRoleArn", codebuildRoleArn)
    def getComponentRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("componentRoleArn", componentRoleArn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDeploymentStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentStatus] =
      ZIO.succeed(deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, StatusMessage] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentAccountConnectionId
        : ZIO[Any, AwsError, EnvironmentAccountConnectionId] =
      AwsError.unwrapOptionField(
        "environmentAccountConnectionId",
        environmentAccountConnectionId
      )
    def getEnvironmentAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("environmentAccountId", environmentAccountId)
    def getLastDeploymentAttemptedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentAttemptedAt)
    def getLastDeploymentSucceededAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentSucceededAt)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getProtonServiceRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("protonServiceRoleArn", protonServiceRoleArn)
    def getProvisioning: ZIO[Any, AwsError, zio.aws.proton.model.Provisioning] =
      AwsError.unwrapOptionField("provisioning", provisioning)
    def getProvisioningRepository
        : ZIO[Any, AwsError, zio.aws.proton.model.RepositoryBranch.ReadOnly] =
      AwsError.unwrapOptionField(
        "provisioningRepository",
        provisioningRepository
      )
    def getSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("spec", spec)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.Environment
  ) extends zio.aws.proton.model.Environment.ReadOnly {
    override val arn: EnvironmentArn =
      zio.aws.proton.model.primitives.EnvironmentArn(impl.arn())
    override val codebuildRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.codebuildRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val componentRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.componentRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val deploymentStatus: zio.aws.proton.model.DeploymentStatus =
      zio.aws.proton.model.DeploymentStatus.wrap(impl.deploymentStatus())
    override val deploymentStatusMessage: Optional[StatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val environmentAccountConnectionId
        : Optional[EnvironmentAccountConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentAccountConnectionId())
      .map(value =>
        zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(value)
      )
    override val environmentAccountId: Optional[AwsAccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentAccountId())
        .map(value => zio.aws.proton.model.primitives.AwsAccountId(value))
    override val lastDeploymentAttemptedAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentAttemptedAt())
    override val lastDeploymentSucceededAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentSucceededAt())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val protonServiceRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.protonServiceRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val provisioning: Optional[zio.aws.proton.model.Provisioning] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioning())
        .map(value => zio.aws.proton.model.Provisioning.wrap(value))
    override val provisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningRepository())
        .map(value => zio.aws.proton.model.RepositoryBranch.wrap(value))
    override val spec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.spec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMinorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.Environment
  ): zio.aws.proton.model.Environment.ReadOnly = new Wrapper(impl)
}
