package zio.aws.proton.model
import zio.aws.proton.model.primitives.EnvironmentAccountConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentAccountConnectionRequest(
    id: EnvironmentAccountConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionRequest = {
    import DeleteEnvironmentAccountConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionRequest
      .builder()
      .id(EnvironmentAccountConnectionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.DeleteEnvironmentAccountConnectionRequest.ReadOnly =
    zio.aws.proton.model.DeleteEnvironmentAccountConnectionRequest
      .wrap(buildAwsValue())
}
object DeleteEnvironmentAccountConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.DeleteEnvironmentAccountConnectionRequest =
      zio.aws.proton.model.DeleteEnvironmentAccountConnectionRequest(id)
    def id: EnvironmentAccountConnectionId
    def getId: ZIO[Any, Nothing, EnvironmentAccountConnectionId] =
      ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionRequest
  ) extends zio.aws.proton.model.DeleteEnvironmentAccountConnectionRequest.ReadOnly {
    override val id: EnvironmentAccountConnectionId =
      zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentAccountConnectionRequest
  ): zio.aws.proton.model.DeleteEnvironmentAccountConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
