package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  TemplateVersionPart,
  Description,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateServiceTemplateVersionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    compatibleEnvironmentTemplates: Iterable[
      zio.aws.proton.model.CompatibleEnvironmentTemplateInput
    ],
    description: Optional[Description] = Optional.Absent,
    majorVersion: Optional[TemplateVersionPart] = Optional.Absent,
    source: zio.aws.proton.model.TemplateVersionSourceInput,
    supportedComponentSources: Optional[
      Iterable[zio.aws.proton.model.ServiceTemplateSupportedComponentSourceType]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.proton.model.Tag]] = Optional.Absent,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionRequest = {
    import CreateServiceTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .compatibleEnvironmentTemplates(compatibleEnvironmentTemplates.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        majorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.majorVersion)
      .source(source.buildAwsValue())
      .optionallyWith(
        supportedComponentSources.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedComponentSourcesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateServiceTemplateVersionRequest.ReadOnly =
    zio.aws.proton.model.CreateServiceTemplateVersionRequest
      .wrap(buildAwsValue())
}
object CreateServiceTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateServiceTemplateVersionRequest =
      zio.aws.proton.model.CreateServiceTemplateVersionRequest(
        clientToken.map(value => value),
        compatibleEnvironmentTemplates.map { item =>
          item.asEditable
        },
        description.map(value => value),
        majorVersion.map(value => value),
        source.asEditable,
        supportedComponentSources.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        templateName
      )
    def clientToken: Optional[ClientToken]
    def compatibleEnvironmentTemplates
        : List[zio.aws.proton.model.CompatibleEnvironmentTemplateInput.ReadOnly]
    def description: Optional[Description]
    def majorVersion: Optional[TemplateVersionPart]
    def source: zio.aws.proton.model.TemplateVersionSourceInput.ReadOnly
    def supportedComponentSources: Optional[
      List[zio.aws.proton.model.ServiceTemplateSupportedComponentSourceType]
    ]
    def tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]]
    def templateName: ResourceName
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCompatibleEnvironmentTemplates: ZIO[Any, Nothing, List[
      zio.aws.proton.model.CompatibleEnvironmentTemplateInput.ReadOnly
    ]] = ZIO.succeed(compatibleEnvironmentTemplates)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMajorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("majorVersion", majorVersion)
    def getSource: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.TemplateVersionSourceInput.ReadOnly
    ] = ZIO.succeed(source)
    def getSupportedComponentSources: ZIO[Any, AwsError, List[
      zio.aws.proton.model.ServiceTemplateSupportedComponentSourceType
    ]] = AwsError.unwrapOptionField(
      "supportedComponentSources",
      supportedComponentSources
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionRequest
  ) extends zio.aws.proton.model.CreateServiceTemplateVersionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.proton.model.primitives.ClientToken(value))
    override val compatibleEnvironmentTemplates: List[
      zio.aws.proton.model.CompatibleEnvironmentTemplateInput.ReadOnly
    ] = impl
      .compatibleEnvironmentTemplates()
      .asScala
      .map { item =>
        zio.aws.proton.model.CompatibleEnvironmentTemplateInput.wrap(item)
      }
      .toList
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val majorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.majorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
    override val source
        : zio.aws.proton.model.TemplateVersionSourceInput.ReadOnly =
      zio.aws.proton.model.TemplateVersionSourceInput.wrap(impl.source())
    override val supportedComponentSources: Optional[
      List[zio.aws.proton.model.ServiceTemplateSupportedComponentSourceType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedComponentSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.ServiceTemplateSupportedComponentSourceType
            .wrap(item)
        }.toList
      )
    override val tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Tag.wrap(item)
          }.toList
        )
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionRequest
  ): zio.aws.proton.model.CreateServiceTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
