package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetEnvironmentTemplateResponse(
    environmentTemplate: zio.aws.proton.model.EnvironmentTemplate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateResponse = {
    import GetEnvironmentTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateResponse
      .builder()
      .environmentTemplate(environmentTemplate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetEnvironmentTemplateResponse.ReadOnly =
    zio.aws.proton.model.GetEnvironmentTemplateResponse.wrap(buildAwsValue())
}
object GetEnvironmentTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetEnvironmentTemplateResponse =
      zio.aws.proton.model
        .GetEnvironmentTemplateResponse(environmentTemplate.asEditable)
    def environmentTemplate: zio.aws.proton.model.EnvironmentTemplate.ReadOnly
    def getEnvironmentTemplate
        : ZIO[Any, Nothing, zio.aws.proton.model.EnvironmentTemplate.ReadOnly] =
      ZIO.succeed(environmentTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateResponse
  ) extends zio.aws.proton.model.GetEnvironmentTemplateResponse.ReadOnly {
    override val environmentTemplate
        : zio.aws.proton.model.EnvironmentTemplate.ReadOnly =
      zio.aws.proton.model.EnvironmentTemplate.wrap(impl.environmentTemplate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateResponse
  ): zio.aws.proton.model.GetEnvironmentTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
