package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentTemplateResponse(
    environmentTemplate: zio.aws.proton.model.EnvironmentTemplate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateResponse = {
    import UpdateEnvironmentTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateResponse
      .builder()
      .environmentTemplate(environmentTemplate.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateEnvironmentTemplateResponse.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentTemplateResponse.wrap(buildAwsValue())
}
object UpdateEnvironmentTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateEnvironmentTemplateResponse =
      zio.aws.proton.model
        .UpdateEnvironmentTemplateResponse(environmentTemplate.asEditable)
    def environmentTemplate: zio.aws.proton.model.EnvironmentTemplate.ReadOnly
    def getEnvironmentTemplate
        : ZIO[Any, Nothing, zio.aws.proton.model.EnvironmentTemplate.ReadOnly] =
      ZIO.succeed(environmentTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateResponse
  ) extends zio.aws.proton.model.UpdateEnvironmentTemplateResponse.ReadOnly {
    override val environmentTemplate
        : zio.aws.proton.model.EnvironmentTemplate.ReadOnly =
      zio.aws.proton.model.EnvironmentTemplate.wrap(impl.environmentTemplate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateResponse
  ): zio.aws.proton.model.UpdateEnvironmentTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
