package zio.aws.proton.model
import scala.jdk.CollectionConverters._
sealed trait RepositorySyncStatus {
  def unwrap: software.amazon.awssdk.services.proton.model.RepositorySyncStatus
}
object RepositorySyncStatus {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.RepositorySyncStatus
  ): zio.aws.proton.model.RepositorySyncStatus = value match {
    case software.amazon.awssdk.services.proton.model.RepositorySyncStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.RepositorySyncStatus.INITIATED =>
      val r = INITIATED
      r
    case software.amazon.awssdk.services.proton.model.RepositorySyncStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.proton.model.RepositorySyncStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.proton.model.RepositorySyncStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.proton.model.RepositorySyncStatus.QUEUED =>
      val r = QUEUED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.RepositorySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositorySyncStatus =
      software.amazon.awssdk.services.proton.model.RepositorySyncStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIATED extends zio.aws.proton.model.RepositorySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositorySyncStatus =
      software.amazon.awssdk.services.proton.model.RepositorySyncStatus.INITIATED
  }
  case object IN_PROGRESS extends zio.aws.proton.model.RepositorySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositorySyncStatus =
      software.amazon.awssdk.services.proton.model.RepositorySyncStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.proton.model.RepositorySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositorySyncStatus =
      software.amazon.awssdk.services.proton.model.RepositorySyncStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.proton.model.RepositorySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositorySyncStatus =
      software.amazon.awssdk.services.proton.model.RepositorySyncStatus.FAILED
  }
  case object QUEUED extends zio.aws.proton.model.RepositorySyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositorySyncStatus =
      software.amazon.awssdk.services.proton.model.RepositorySyncStatus.QUEUED
  }
}
