package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetComponentResponse(
    component: Optional[zio.aws.proton.model.Component] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetComponentResponse = {
    import GetComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetComponentResponse
      .builder()
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetComponentResponse.ReadOnly =
    zio.aws.proton.model.GetComponentResponse.wrap(buildAwsValue())
}
object GetComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetComponentResponse =
      zio.aws.proton.model
        .GetComponentResponse(component.map(value => value.asEditable))
    def component: Optional[zio.aws.proton.model.Component.ReadOnly]
    def getComponent
        : ZIO[Any, AwsError, zio.aws.proton.model.Component.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetComponentResponse
  ) extends zio.aws.proton.model.GetComponentResponse.ReadOnly {
    override val component: Optional[zio.aws.proton.model.Component.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.component())
        .map(value => zio.aws.proton.model.Component.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetComponentResponse
  ): zio.aws.proton.model.GetComponentResponse.ReadOnly = new Wrapper(impl)
}
