package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateServiceInstanceResponse(
    serviceInstance: zio.aws.proton.model.ServiceInstance
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceInstanceResponse = {
    import UpdateServiceInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceInstanceResponse
      .builder()
      .serviceInstance(serviceInstance.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateServiceInstanceResponse.ReadOnly =
    zio.aws.proton.model.UpdateServiceInstanceResponse.wrap(buildAwsValue())
}
object UpdateServiceInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceInstanceResponse =
      zio.aws.proton.model
        .UpdateServiceInstanceResponse(serviceInstance.asEditable)
    def serviceInstance: zio.aws.proton.model.ServiceInstance.ReadOnly
    def getServiceInstance
        : ZIO[Any, Nothing, zio.aws.proton.model.ServiceInstance.ReadOnly] =
      ZIO.succeed(serviceInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceInstanceResponse
  ) extends zio.aws.proton.model.UpdateServiceInstanceResponse.ReadOnly {
    override val serviceInstance
        : zio.aws.proton.model.ServiceInstance.ReadOnly =
      zio.aws.proton.model.ServiceInstance.wrap(impl.serviceInstance())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceInstanceResponse
  ): zio.aws.proton.model.UpdateServiceInstanceResponse.ReadOnly = new Wrapper(
    impl
  )
}
