package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteComponentRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteComponentRequest = {
    import DeleteComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteComponentRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteComponentRequest.ReadOnly =
    zio.aws.proton.model.DeleteComponentRequest.wrap(buildAwsValue())
}
object DeleteComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteComponentRequest =
      zio.aws.proton.model.DeleteComponentRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteComponentRequest
  ) extends zio.aws.proton.model.DeleteComponentRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteComponentRequest
  ): zio.aws.proton.model.DeleteComponentRequest.ReadOnly = new Wrapper(impl)
}
