package zio.aws.proton.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.proton.model.primitives.{ResourceName, NextToken, MaxPageResults}
import scala.jdk.CollectionConverters._
final case class ListServiceInstancesRequest(
    maxResults: Optional[MaxPageResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    serviceName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest = {
    import ListServiceInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        serviceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListServiceInstancesRequest.ReadOnly =
    zio.aws.proton.model.ListServiceInstancesRequest.wrap(buildAwsValue())
}
object ListServiceInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServiceInstancesRequest =
      zio.aws.proton.model.ListServiceInstancesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        serviceName.map(value => value)
      )
    def maxResults: Optional[MaxPageResults]
    def nextToken: Optional[NextToken]
    def serviceName: Optional[ResourceName]
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
  ) extends zio.aws.proton.model.ListServiceInstancesRequest.ReadOnly {
    override val maxResults: Optional[MaxPageResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val serviceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
  ): zio.aws.proton.model.ListServiceInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
