package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentTemplateRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateRequest = {
    import DeleteEnvironmentTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.DeleteEnvironmentTemplateRequest.ReadOnly =
    zio.aws.proton.model.DeleteEnvironmentTemplateRequest.wrap(buildAwsValue())
}
object DeleteEnvironmentTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteEnvironmentTemplateRequest =
      zio.aws.proton.model.DeleteEnvironmentTemplateRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateRequest
  ) extends zio.aws.proton.model.DeleteEnvironmentTemplateRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateRequest
  ): zio.aws.proton.model.DeleteEnvironmentTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
