package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelComponentDeploymentResponse(
    component: zio.aws.proton.model.Component
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CancelComponentDeploymentResponse = {
    import CancelComponentDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CancelComponentDeploymentResponse
      .builder()
      .component(component.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CancelComponentDeploymentResponse.ReadOnly =
    zio.aws.proton.model.CancelComponentDeploymentResponse.wrap(buildAwsValue())
}
object CancelComponentDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CancelComponentDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CancelComponentDeploymentResponse =
      zio.aws.proton.model
        .CancelComponentDeploymentResponse(component.asEditable)
    def component: zio.aws.proton.model.Component.ReadOnly
    def getComponent
        : ZIO[Any, Nothing, zio.aws.proton.model.Component.ReadOnly] =
      ZIO.succeed(component)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CancelComponentDeploymentResponse
  ) extends zio.aws.proton.model.CancelComponentDeploymentResponse.ReadOnly {
    override val component: zio.aws.proton.model.Component.ReadOnly =
      zio.aws.proton.model.Component.wrap(impl.component())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CancelComponentDeploymentResponse
  ): zio.aws.proton.model.CancelComponentDeploymentResponse.ReadOnly =
    new Wrapper(impl)
}
