package zio.aws.proton.model
import zio.aws.proton.model.primitives.{EnvironmentAccountConnectionId, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentAccountConnectionRequest(
    componentRoleArn: Optional[Arn] = Optional.Absent,
    id: EnvironmentAccountConnectionId,
    roleArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest = {
    import UpdateEnvironmentAccountConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
      .builder()
      .optionallyWith(
        componentRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.componentRoleArn)
      .id(EnvironmentAccountConnectionId.unwrap(id): java.lang.String)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest
      .wrap(buildAwsValue())
}
object UpdateEnvironmentAccountConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest =
      zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest(
        componentRoleArn.map(value => value),
        id,
        roleArn.map(value => value)
      )
    def componentRoleArn: Optional[Arn]
    def id: EnvironmentAccountConnectionId
    def roleArn: Optional[Arn]
    def getComponentRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("componentRoleArn", componentRoleArn)
    def getId: ZIO[Any, Nothing, EnvironmentAccountConnectionId] =
      ZIO.succeed(id)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
  ) extends zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest.ReadOnly {
    override val componentRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.componentRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val id: EnvironmentAccountConnectionId =
      zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(impl.id())
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentAccountConnectionRequest
  ): zio.aws.proton.model.UpdateEnvironmentAccountConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
