package zio.aws.proton.model
import zio.aws.proton.model.primitives.PipelineRoleArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAccountSettingsRequest(
    pipelineProvisioningRepository: Optional[
      zio.aws.proton.model.RepositoryBranchInput
    ] = Optional.Absent,
    pipelineServiceRoleArn: Optional[PipelineRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest = {
    import UpdateAccountSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest
      .builder()
      .optionallyWith(
        pipelineProvisioningRepository.map(value => value.buildAwsValue())
      )(_.pipelineProvisioningRepository)
      .optionallyWith(
        pipelineServiceRoleArn.map(value =>
          PipelineRoleArn.unwrap(value): java.lang.String
        )
      )(_.pipelineServiceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateAccountSettingsRequest.ReadOnly =
    zio.aws.proton.model.UpdateAccountSettingsRequest.wrap(buildAwsValue())
}
object UpdateAccountSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateAccountSettingsRequest =
      zio.aws.proton.model.UpdateAccountSettingsRequest(
        pipelineProvisioningRepository.map(value => value.asEditable),
        pipelineServiceRoleArn.map(value => value)
      )
    def pipelineProvisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranchInput.ReadOnly]
    def pipelineServiceRoleArn: Optional[PipelineRoleArn]
    def getPipelineProvisioningRepository: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.RepositoryBranchInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pipelineProvisioningRepository",
      pipelineProvisioningRepository
    )
    def getPipelineServiceRoleArn: ZIO[Any, AwsError, PipelineRoleArn] =
      AwsError.unwrapOptionField(
        "pipelineServiceRoleArn",
        pipelineServiceRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest
  ) extends zio.aws.proton.model.UpdateAccountSettingsRequest.ReadOnly {
    override val pipelineProvisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranchInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineProvisioningRepository())
        .map(value => zio.aws.proton.model.RepositoryBranchInput.wrap(value))
    override val pipelineServiceRoleArn: Optional[PipelineRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineServiceRoleArn())
        .map(value => zio.aws.proton.model.primitives.PipelineRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest
  ): zio.aws.proton.model.UpdateAccountSettingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
