package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  ServiceArn,
  Timestamp,
  Description,
  StatusMessage,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class ServiceSummary(
    arn: ServiceArn,
    createdAt: Timestamp,
    description: Optional[Description] = Optional.Absent,
    lastModifiedAt: Timestamp,
    name: ResourceName,
    status: zio.aws.proton.model.ServiceStatus,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ServiceSummary = {
    import ServiceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ServiceSummary
      .builder()
      .arn(ServiceArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .name(ResourceName.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ServiceSummary.ReadOnly =
    zio.aws.proton.model.ServiceSummary.wrap(buildAwsValue())
}
object ServiceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ServiceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ServiceSummary =
      zio.aws.proton.model.ServiceSummary(
        arn,
        createdAt,
        description.map(value => value),
        lastModifiedAt,
        name,
        status,
        statusMessage.map(value => value),
        templateName
      )
    def arn: ServiceArn
    def createdAt: Timestamp
    def description: Optional[Description]
    def lastModifiedAt: Timestamp
    def name: ResourceName
    def status: zio.aws.proton.model.ServiceStatus
    def statusMessage: Optional[StatusMessage]
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, ServiceArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, zio.aws.proton.model.ServiceStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ServiceSummary
  ) extends zio.aws.proton.model.ServiceSummary.ReadOnly {
    override val arn: ServiceArn =
      zio.aws.proton.model.primitives.ServiceArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val status: zio.aws.proton.model.ServiceStatus =
      zio.aws.proton.model.ServiceStatus.wrap(impl.status())
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ServiceSummary
  ): zio.aws.proton.model.ServiceSummary.ReadOnly = new Wrapper(impl)
}
