package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListServiceTemplateVersionsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    templateVersions: Iterable[
      zio.aws.proton.model.ServiceTemplateVersionSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse = {
    import ListServiceTemplateVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templateVersions(templateVersions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListServiceTemplateVersionsResponse.ReadOnly =
    zio.aws.proton.model.ListServiceTemplateVersionsResponse
      .wrap(buildAwsValue())
}
object ListServiceTemplateVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServiceTemplateVersionsResponse =
      zio.aws.proton.model.ListServiceTemplateVersionsResponse(
        nextToken.map(value => value),
        templateVersions.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def templateVersions
        : List[zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplateVersions: ZIO[Any, Nothing, List[
      zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly
    ]] = ZIO.succeed(templateVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse
  ) extends zio.aws.proton.model.ListServiceTemplateVersionsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val templateVersions
        : List[zio.aws.proton.model.ServiceTemplateVersionSummary.ReadOnly] =
      impl
        .templateVersions()
        .asScala
        .map { item =>
          zio.aws.proton.model.ServiceTemplateVersionSummary.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse
  ): zio.aws.proton.model.ListServiceTemplateVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
