package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, EmptyNextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListServicePipelineOutputsRequest(
    nextToken: Optional[EmptyNextToken] = Optional.Absent,
    serviceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest = {
    import ListServicePipelineOutputsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListServicePipelineOutputsRequest.ReadOnly =
    zio.aws.proton.model.ListServicePipelineOutputsRequest.wrap(buildAwsValue())
}
object ListServicePipelineOutputsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServicePipelineOutputsRequest =
      zio.aws.proton.model.ListServicePipelineOutputsRequest(
        nextToken.map(value => value),
        serviceName
      )
    def nextToken: Optional[EmptyNextToken]
    def serviceName: ResourceName
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest
  ) extends zio.aws.proton.model.ListServicePipelineOutputsRequest.ReadOnly {
    override val nextToken: Optional[EmptyNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServicePipelineOutputsRequest
  ): zio.aws.proton.model.ListServicePipelineOutputsRequest.ReadOnly =
    new Wrapper(impl)
}
