package zio.aws.proton.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.proton.model.primitives.{NextToken, MaxPageResults}
import scala.jdk.CollectionConverters._
final case class ListEnvironmentsRequest(
    environmentTemplates: Optional[
      Iterable[zio.aws.proton.model.EnvironmentTemplateFilter]
    ] = Optional.Absent,
    maxResults: Optional[MaxPageResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest = {
    import ListEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest
      .builder()
      .optionallyWith(
        environmentTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentTemplates)
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListEnvironmentsRequest.ReadOnly =
    zio.aws.proton.model.ListEnvironmentsRequest.wrap(buildAwsValue())
}
object ListEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListEnvironmentsRequest =
      zio.aws.proton.model.ListEnvironmentsRequest(
        environmentTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def environmentTemplates: Optional[
      List[zio.aws.proton.model.EnvironmentTemplateFilter.ReadOnly]
    ]
    def maxResults: Optional[MaxPageResults]
    def nextToken: Optional[NextToken]
    def getEnvironmentTemplates: ZIO[Any, AwsError, List[
      zio.aws.proton.model.EnvironmentTemplateFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("environmentTemplates", environmentTemplates)
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest
  ) extends zio.aws.proton.model.ListEnvironmentsRequest.ReadOnly {
    override val environmentTemplates: Optional[
      List[zio.aws.proton.model.EnvironmentTemplateFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.EnvironmentTemplateFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxPageResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentsRequest
  ): zio.aws.proton.model.ListEnvironmentsRequest.ReadOnly = new Wrapper(impl)
}
