package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  EnvironmentAccountConnectionId,
  Timestamp,
  Arn,
  EnvironmentAccountConnectionArn,
  AwsAccountId,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class EnvironmentAccountConnectionSummary(
    arn: EnvironmentAccountConnectionArn,
    componentRoleArn: Optional[Arn] = Optional.Absent,
    environmentAccountId: AwsAccountId,
    environmentName: ResourceName,
    id: EnvironmentAccountConnectionId,
    lastModifiedAt: Timestamp,
    managementAccountId: AwsAccountId,
    requestedAt: Timestamp,
    roleArn: Arn,
    status: zio.aws.proton.model.EnvironmentAccountConnectionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary = {
    import EnvironmentAccountConnectionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary
      .builder()
      .arn(EnvironmentAccountConnectionArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        componentRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.componentRoleArn)
      .environmentAccountId(
        AwsAccountId.unwrap(environmentAccountId): java.lang.String
      )
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .id(EnvironmentAccountConnectionId.unwrap(id): java.lang.String)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .managementAccountId(
        AwsAccountId.unwrap(managementAccountId): java.lang.String
      )
      .requestedAt(Timestamp.unwrap(requestedAt): Instant)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly =
    zio.aws.proton.model.EnvironmentAccountConnectionSummary
      .wrap(buildAwsValue())
}
object EnvironmentAccountConnectionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.EnvironmentAccountConnectionSummary =
      zio.aws.proton.model.EnvironmentAccountConnectionSummary(
        arn,
        componentRoleArn.map(value => value),
        environmentAccountId,
        environmentName,
        id,
        lastModifiedAt,
        managementAccountId,
        requestedAt,
        roleArn,
        status
      )
    def arn: EnvironmentAccountConnectionArn
    def componentRoleArn: Optional[Arn]
    def environmentAccountId: AwsAccountId
    def environmentName: ResourceName
    def id: EnvironmentAccountConnectionId
    def lastModifiedAt: Timestamp
    def managementAccountId: AwsAccountId
    def requestedAt: Timestamp
    def roleArn: Arn
    def status: zio.aws.proton.model.EnvironmentAccountConnectionStatus
    def getArn: ZIO[Any, Nothing, EnvironmentAccountConnectionArn] =
      ZIO.succeed(arn)
    def getComponentRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("componentRoleArn", componentRoleArn)
    def getEnvironmentAccountId: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(environmentAccountId)
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, EnvironmentAccountConnectionId] =
      ZIO.succeed(id)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getManagementAccountId: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(managementAccountId)
    def getRequestedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(requestedAt)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.EnvironmentAccountConnectionStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary
  ) extends zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly {
    override val arn: EnvironmentAccountConnectionArn =
      zio.aws.proton.model.primitives
        .EnvironmentAccountConnectionArn(impl.arn())
    override val componentRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.componentRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val environmentAccountId: AwsAccountId =
      zio.aws.proton.model.primitives.AwsAccountId(impl.environmentAccountId())
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val id: EnvironmentAccountConnectionId =
      zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(impl.id())
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val managementAccountId: AwsAccountId =
      zio.aws.proton.model.primitives.AwsAccountId(impl.managementAccountId())
    override val requestedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.requestedAt())
    override val roleArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.roleArn())
    override val status
        : zio.aws.proton.model.EnvironmentAccountConnectionStatus =
      zio.aws.proton.model.EnvironmentAccountConnectionStatus
        .wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary
  ): zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly =
    new Wrapper(impl)
}
