package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  SpecContents,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateServiceInstanceRequest(
    deploymentType: zio.aws.proton.model.DeploymentUpdateType,
    name: ResourceName,
    serviceName: ResourceName,
    spec: Optional[SpecContents] = Optional.Absent,
    templateMajorVersion: Optional[TemplateVersionPart] = Optional.Absent,
    templateMinorVersion: Optional[TemplateVersionPart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceInstanceRequest = {
    import UpdateServiceInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceInstanceRequest
      .builder()
      .deploymentType(deploymentType.unwrap)
      .name(ResourceName.unwrap(name): java.lang.String)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .optionallyWith(
        spec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.spec)
      .optionallyWith(
        templateMajorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMajorVersion)
      .optionallyWith(
        templateMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMinorVersion)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateServiceInstanceRequest.ReadOnly =
    zio.aws.proton.model.UpdateServiceInstanceRequest.wrap(buildAwsValue())
}
object UpdateServiceInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceInstanceRequest =
      zio.aws.proton.model.UpdateServiceInstanceRequest(
        deploymentType,
        name,
        serviceName,
        spec.map(value => value),
        templateMajorVersion.map(value => value),
        templateMinorVersion.map(value => value)
      )
    def deploymentType: zio.aws.proton.model.DeploymentUpdateType
    def name: ResourceName
    def serviceName: ResourceName
    def spec: Optional[SpecContents]
    def templateMajorVersion: Optional[TemplateVersionPart]
    def templateMinorVersion: Optional[TemplateVersionPart]
    def getDeploymentType
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentUpdateType] =
      ZIO.succeed(deploymentType)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
    def getSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("spec", spec)
    def getTemplateMajorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMajorVersion", templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMinorVersion", templateMinorVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceInstanceRequest
  ) extends zio.aws.proton.model.UpdateServiceInstanceRequest.ReadOnly {
    override val deploymentType: zio.aws.proton.model.DeploymentUpdateType =
      zio.aws.proton.model.DeploymentUpdateType.wrap(impl.deploymentType())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
    override val spec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.spec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
    override val templateMajorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMajorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
    override val templateMinorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMinorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceInstanceRequest
  ): zio.aws.proton.model.UpdateServiceInstanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
