package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentTemplateVersionResponse(
    environmentTemplateVersion: zio.aws.proton.model.EnvironmentTemplateVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionResponse = {
    import UpdateEnvironmentTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionResponse
      .builder()
      .environmentTemplateVersion(environmentTemplateVersion.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse
      .wrap(buildAwsValue())
}
object UpdateEnvironmentTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse =
      zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse(
        environmentTemplateVersion.asEditable
      )
    def environmentTemplateVersion
        : zio.aws.proton.model.EnvironmentTemplateVersion.ReadOnly
    def getEnvironmentTemplateVersion: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.EnvironmentTemplateVersion.ReadOnly
    ] = ZIO.succeed(environmentTemplateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionResponse
  ) extends zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse.ReadOnly {
    override val environmentTemplateVersion
        : zio.aws.proton.model.EnvironmentTemplateVersion.ReadOnly =
      zio.aws.proton.model.EnvironmentTemplateVersion
        .wrap(impl.environmentTemplateVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateVersionResponse
  ): zio.aws.proton.model.UpdateEnvironmentTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
